/*
 * Decompiled with CFR 0.152.
 */
package apps;

import apps.Executable;
import data.OutputManager;
import imaging.DW_Scheme;
import java.util.logging.Logger;
import misc.SphericalPoints;
import numerics.RealMatrix;
import sphfunc.BasisSumFactory;
import sphfunc.LinearBasisFunction;
import sphfunc.LinearBasisSum;
import sphfunc.RBF_Sum;
import sphfunc.TuchRBF_Sum;
import tools.CL_Initializer;

public class QBallMX
extends Executable {
    private static Logger logger = Logger.getLogger("apps/QBallMX");
    private static double dataSmoothSigma;
    private LinearBasisSum lbs;
    private LinearBasisFunction lbf;
    private DW_Scheme imp;
    private int basis;
    private double[][] normQs;
    private int numQPoints;
    private double[][] odfBasisCentres;
    private int numOdfBasisPoints;
    private RealMatrix yMat;

    public QBallMX(String[] stringArray) {
        super(stringArray);
    }

    @Override
    public void initDefaultVals() {
        dataSmoothSigma = 0.1308996938995747;
    }

    @Override
    public void initOptions(String[] stringArray) {
        CL_Initializer.CL_init(stringArray);
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-smoothingsigma")) continue;
            dataSmoothSigma = Double.parseDouble(stringArray[i + 1]);
            CL_Initializer.markAsParsed(i, 2);
        }
        CL_Initializer.checkParsing(stringArray);
        CL_Initializer.initImagingScheme();
    }

    @Override
    public void initVariables() {
        this.basis = CL_Initializer.basisType;
        this.lbs = BasisSumFactory.getBasisSum(this.basis);
        logger.info("BASIS FUNCTION SETTINGS:");
        logger.info(this.lbs.getSettings());
        this.imp = CL_Initializer.imPars;
        this.normQs = this.imp.getNonZeroG_Dirs();
        this.numQPoints = this.normQs.length;
        this.odfBasisCentres = SphericalPoints.getElecPointSet(this.lbs.numBasisFunctions());
        this.numOdfBasisPoints = this.odfBasisCentres.length;
        this.yMat = new RealMatrix(this.numQPoints, this.lbs.numBasisFunctions());
    }

    @Override
    public void execute(OutputManager outputManager) {
        RealMatrix realMatrix;
        Object object;
        int n;
        for (int i = 0; i < this.lbs.numBasisFunctions(); ++i) {
            this.lbf = this.lbs.basisFunction(i);
            for (n = 0; n < this.numQPoints; ++n) {
                this.yMat.setEntry(n, i, this.lbf.getRadius(this.normQs[n][0], this.normQs[n][1], this.normQs[n][2]));
            }
        }
        RealMatrix realMatrix2 = new RealMatrix(this.numOdfBasisPoints, this.lbs.numBasisFunctions());
        for (n = 0; n < this.lbs.numBasisFunctions(); ++n) {
            this.lbf = this.lbs.basisFunction(n);
            for (int i = 0; i < this.numOdfBasisPoints; ++i) {
                realMatrix2.setEntry(i, n, this.lbf.greatCircleIntegral(this.odfBasisCentres[i]));
            }
        }
        if (this.basis != 1) {
            object = new RealMatrix(this.numOdfBasisPoints, this.lbs.numBasisFunctions());
            for (int i = 0; i < this.lbs.numBasisFunctions(); ++i) {
                this.lbf = this.lbs.basisFunction(i);
                for (int j = 0; j < this.numOdfBasisPoints; ++j) {
                    ((RealMatrix)object).setEntry(j, i, this.lbf.getRadius(this.odfBasisCentres[j][0], this.odfBasisCentres[j][1], this.odfBasisCentres[j][2]));
                }
            }
            RealMatrix realMatrix3 = ((RealMatrix)object).pseudoInv();
            if (this.basis == 1) {
                realMatrix3 = QBallMX.tuchsNormalization(realMatrix3, this.numOdfBasisPoints);
            }
            RealMatrix realMatrix4 = this.yMat.pseudoInv();
            realMatrix = realMatrix3.product(realMatrix2);
            realMatrix = realMatrix.product(realMatrix4);
        } else {
            RBF_Sum.setPoints(this.normQs);
            TuchRBF_Sum.setSigma(dataSmoothSigma);
            this.lbs = BasisSumFactory.getBasisSum(this.basis);
            logger.info("SMOOTHING FUNCTION SETTINGS:");
            logger.info(this.lbs.getSettings());
            object = new RealMatrix(this.numQPoints, this.lbs.numBasisFunctions());
            for (int i = 0; i < this.lbs.numBasisFunctions(); ++i) {
                this.lbf = this.lbs.basisFunction(i);
                for (int j = 0; j < this.numQPoints; ++j) {
                    ((RealMatrix)object).setEntry(j, i, this.lbf.getRadius(this.normQs[j][0], this.normQs[j][1], this.normQs[j][2]));
                }
            }
            this.yMat = this.yMat.pseudoInv();
            object = QBallMX.tuchsNormalization((RealMatrix)object, this.numQPoints);
            realMatrix = realMatrix2.product(this.yMat);
            realMatrix = realMatrix.product((RealMatrix)object);
        }
        object = new double[realMatrix.columns()];
        for (int i = 0; i < realMatrix.rows(); ++i) {
            for (int j = 0; j < realMatrix.columns(); ++j) {
                object[j] = realMatrix.entries[i][j];
            }
            outputManager.output((double[])object);
        }
        outputManager.close();
    }

    private static RealMatrix tuchsNormalization(RealMatrix realMatrix, int n) {
        int n2;
        double[] dArray = new double[n];
        for (n2 = 0; n2 < n; ++n2) {
            dArray[n2] = 0.0;
        }
        for (n2 = 0; n2 < n; ++n2) {
            for (int i = 0; i < n; ++i) {
                int n3 = n2;
                dArray[n3] = dArray[n3] + realMatrix.entry(n2, i);
            }
        }
        RealMatrix realMatrix2 = new RealMatrix(n, n);
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                d = realMatrix.entry(i, j) / dArray[j];
                realMatrix2.setEntry(j, i, d);
            }
        }
        return realMatrix2;
    }
}

