/*
 * Decompiled with CFR 0.152.
 */
package apps;

import apps.Executable;
import data.OutputManager;
import data.ScannerOrderDataSource;
import java.util.logging.Logger;
import tools.CL_Initializer;

public class ScannerToVoxel
extends Executable {
    private static Logger logger = Logger.getLogger("camino.apps.ScannerToVoxel");
    private static int components;
    ScannerOrderDataSource data;

    public ScannerToVoxel(String[] stringArray) {
        super(stringArray);
    }

    @Override
    public void initDefaultVals() {
        components = 1;
    }

    @Override
    public void initOptions(String[] stringArray) {
        CL_Initializer.inputDataType = "float";
        OutputManager.outputDataType = "float";
        CL_Initializer.CL_init(stringArray);
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-components")) continue;
            components = Integer.parseInt(stringArray[i + 1]);
            CL_Initializer.markAsParsed(i);
            CL_Initializer.markAsParsed(i + 1);
        }
        CL_Initializer.checkParsing(stringArray);
    }

    @Override
    public void initVariables() {
        this.data = new ScannerOrderDataSource(CL_Initializer.inputFile, CL_Initializer.numVoxels, components, CL_Initializer.inputDataType);
    }

    @Override
    public void execute(OutputManager outputManager) {
        while (this.data.more()) {
            try {
                double[] dArray = this.data.nextVoxel();
                outputManager.output(dArray);
            }
            catch (Exception exception) {
                logger.warning(exception.toString() + "  (Program will continue)");
            }
        }
        outputManager.close();
    }
}

