/*
 * Decompiled with CFR 0.152.
 */
package apps;

import apps.PD_OrientationViewer;
import imaging.DW_Scheme;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

class SchemePanel
extends JPanel {
    private PD_OrientationViewer container;
    private JRadioButton flipxButton;
    private JRadioButton flipyButton;
    private JRadioButton flipzButton;
    private JRadioButton noFlipButton;
    private String[] comboOptions = new String[]{"X Y Z", "X Z Y", "Y X Z", "Y Z X", "Z X Y", "Z Y X"};
    private JComboBox swapGradsCombo;
    private JButton saveSchemeButton;

    public SchemePanel(PD_OrientationViewer pD_OrientationViewer) {
        this.container = pD_OrientationViewer;
        this.setLayout(new BoxLayout(this, 0));
        this.setBorder(BorderFactory.createTitledBorder("Scheme file options"));
        this.initComponents();
    }

    private void initComponents() {
        this.noFlipButton = new JRadioButton("no flip");
        this.noFlipButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                SchemePanel.this.container.setFlip(0);
            }
        });
        this.noFlipButton.setSelected(true);
        this.add(this.noFlipButton);
        this.flipxButton = new JRadioButton("flip x");
        this.flipxButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                SchemePanel.this.container.setFlip(1);
            }
        });
        this.add(this.flipxButton);
        this.flipyButton = new JRadioButton("flip y");
        this.flipyButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                SchemePanel.this.container.setFlip(2);
            }
        });
        this.add(this.flipyButton);
        this.flipzButton = new JRadioButton("flip z");
        this.flipzButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                SchemePanel.this.container.setFlip(3);
            }
        });
        this.add(this.flipzButton);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.noFlipButton);
        buttonGroup.add(this.flipxButton);
        buttonGroup.add(this.flipyButton);
        buttonGroup.add(this.flipzButton);
        this.swapGradsCombo = new JComboBox<String>(this.comboOptions);
        this.swapGradsCombo.setSelectedIndex(0);
        this.swapGradsCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = new int[3];
                switch (SchemePanel.this.swapGradsCombo.getSelectedIndex()) {
                    case 0: {
                        nArray = DW_Scheme.gradXYZ;
                        break;
                    }
                    case 1: {
                        nArray = DW_Scheme.gradXZY;
                        break;
                    }
                    case 2: {
                        nArray = DW_Scheme.gradYXZ;
                        break;
                    }
                    case 3: {
                        nArray = DW_Scheme.gradYZX;
                        break;
                    }
                    case 4: {
                        nArray = DW_Scheme.gradZXY;
                        break;
                    }
                    case 5: {
                        nArray = DW_Scheme.gradZYX;
                    }
                }
                SchemePanel.this.container.swapDirs(nArray);
            }
        });
        this.add(this.swapGradsCombo);
        this.saveSchemeButton = new JButton("SAVE SCHEME");
        this.saveSchemeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SchemePanel.this.container.writeScheme();
            }
        });
        this.add(this.saveSchemeButton);
    }

    protected void updateFlipButtons(int n) {
        this.flipxButton.setSelected(false);
        this.flipyButton.setSelected(false);
        this.flipzButton.setSelected(false);
        switch (n) {
            case 0: {
                this.noFlipButton.setSelected(true);
                break;
            }
            case 1: {
                this.flipxButton.setSelected(true);
                break;
            }
            case 2: {
                this.flipyButton.setSelected(true);
                break;
            }
            case 3: {
                this.flipzButton.setSelected(true);
            }
        }
        this.container.repaint();
    }

    protected void resetButtons() {
        this.noFlipButton.setSelected(true);
        this.swapGradsCombo.setSelectedIndex(0);
        this.container.repaint();
    }
}

