/*
 * Decompiled with CFR 0.152.
 */
package apps;

import data.DataSynthesizer;
import data.GaussianMixture;
import data.ModelPDF;
import data.OutputManager;
import imaging.DW_Scheme;
import java.util.Random;
import misc.DT;
import misc.LoggedException;
import numerics.RealMatrix;
import numerics.Rotations;
import numerics.Vector3D;
import tools.CL_Initializer;
import tools.FileOutput;

public class SphFuncPICoCalibrationData {
    public static final double DT1_E1_THETA = 0.0;
    public static final double DT1_E1_PHI = 0.0;
    public static final double DT1_E2_THETA = 1.5707963267948966;
    public static final double DT1_E2_PHI = 0.0;
    public static final double DT1_E3_THETA = 1.5707963267948966;
    public static final double DT1_E3_PHI = 1.5707963267948966;
    public static final double DT2_E1_THETA = 1.5707963267948966;
    public static final double DT2_E1_PHI = 1.5707963267948966;
    public static final double DT2_E2_THETA = 1.5707963267948966;
    public static final double DT2_E2_PHI = 0.0;
    public static final double DT2_E3_THETA = 0.0;
    public static final double DT2_E3_PHI = 0.0;
    public static final Vector3D DT1_E1 = Vector3D.vectorFromSPC(1.0, 0.0, 0.0);
    public static final Vector3D DT1_E2 = Vector3D.vectorFromSPC(1.0, 1.5707963267948966, 0.0);
    public static final Vector3D DT1_E3 = Vector3D.vectorFromSPC(1.0, 1.5707963267948966, 1.5707963267948966);
    public static final Vector3D DT2_E1 = Vector3D.vectorFromSPC(1.0, 1.5707963267948966, 1.5707963267948966);
    public static final Vector3D DT2_E2 = Vector3D.vectorFromSPC(1.0, 1.5707963267948966, 0.0);
    public static final Vector3D DT2_E3 = Vector3D.vectorFromSPC(1.0, 0.0, 0.0);
    private static RealMatrix dt1_e1_e1T = null;
    private static RealMatrix dt1_e2_e2T = null;
    private static RealMatrix dt1_e3_e3T = null;
    private static RealMatrix dt2_e1_e1T = null;
    private static RealMatrix dt2_e2_e2T = null;
    private static RealMatrix dt2_e3_e3T = null;
    public static double trace;
    private static OutputManager om;

    public static void main(String[] stringArray) {
        int n;
        int n2;
        int n3;
        Object object;
        int n4;
        CL_Initializer.CL_init(stringArray);
        CL_Initializer.initImagingScheme();
        OutputManager.outputDataType = "float";
        double d = 0.05;
        double d2 = 0.9;
        double d3 = 2.5E-4;
        double d4 = 0.3;
        double d5 = 0.9;
        double d6 = 0.01;
        double d7 = 0.0;
        double d8 = 0.7853981633974483;
        double d9 = 0.08726646259971647;
        double d10 = 0.2;
        double d11 = 0.8;
        double d12 = 0.05;
        double d13 = CL_Initializer.SNR;
        DW_Scheme dW_Scheme = CL_Initializer.imPars;
        int n5 = CL_Initializer.rotationIndex;
        Random random = null;
        if (n5 >= 0) {
            random = new Random(n5);
        }
        int n6 = 0;
        String string = "pico_calibration_info.txt";
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-seed")) {
                n6 = Integer.parseInt(stringArray[i + 1]);
            }
            if (stringArray[i].equals("-onedtfarange")) {
                d = Double.parseDouble(stringArray[i + 1]);
                d2 = Double.parseDouble(stringArray[i + 2]);
                CL_Initializer.markAsParsed(i, 3);
            }
            if (stringArray[i].equals("-onedtfastep")) {
                d3 = Double.parseDouble(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
            }
            if (stringArray[i].equals("-twodtfarange")) {
                d4 = Double.parseDouble(stringArray[i + 1]);
                d5 = Double.parseDouble(stringArray[i + 2]);
                CL_Initializer.markAsParsed(i, 3);
            }
            if (stringArray[i].equals("-twodtfastep")) {
                d6 = Double.parseDouble(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
            }
            if (stringArray[i].equals("-twodtanglerange")) {
                d7 = Double.parseDouble(stringArray[i + 1]);
                d8 = Double.parseDouble(stringArray[i + 2]);
                CL_Initializer.markAsParsed(i, 3);
            }
            if (stringArray[i].equals("-twodtanglestep")) {
                d9 = Double.parseDouble(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
            }
            if (stringArray[i].equals("-twodtmixmax")) {
                d11 = Double.parseDouble(stringArray[i + 1]);
                d10 = 1.0 - d11;
                CL_Initializer.markAsParsed(i, 2);
            }
            if (stringArray[i].equals("-twodtmixstep")) {
                d12 = Double.parseDouble(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
            }
            if (stringArray[i].equals("-trace")) {
                trace = Double.parseDouble(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
            }
            if (!stringArray[i].equals("-infooutputfile")) continue;
            string = stringArray[i + 1];
            CL_Initializer.markAsParsed(i, 2);
        }
        Random random2 = new Random(n6);
        CL_Initializer.checkParsing(stringArray);
        om = new OutputManager();
        if (d2 < d) {
            throw new LoggedException("Specifed one-fibre FA range is negative: " + d + " to " + d2);
        }
        if (d8 < d7 || d8 > 1.5707963267948966) {
            throw new LoggedException("Two-fibre rotation range is wrong (did you specify degrees instead of radians?)");
        }
        if (d5 < d4) {
            throw new LoggedException("Specifed two-fibre FA range is negative: " + d4 + " to " + d5);
        }
        if (d11 < 0.0 || d11 > 1.0) {
            throw new LoggedException("Mixing parameter must range between 0.0 and 1.0, specified maximum was" + d11);
        }
        int n7 = (int)(1.0 + (d2 - d) / d3);
        double[] dArray = new double[n7];
        for (int i = 0; i < n7; ++i) {
            dArray[i] = d + (double)i * d3;
        }
        DT[] dTArray = SphFuncPICoCalibrationData.getOneTensorBlock(dArray, random);
        for (n4 = 0; n4 < n7; ++n4) {
            object = new GaussianMixture(new DT[]{dTArray[n4]}, new double[]{1.0});
            DataSynthesizer dataSynthesizer = new DataSynthesizer((ModelPDF)object, dW_Scheme, d13, 1, random2);
            om.output(dataSynthesizer.nextVoxel());
        }
        n4 = (int)(1.0 + (d5 - d4) / d6);
        object = new double[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            object[n3] = d4 + (double)n3 * d6;
        }
        n3 = (int)(1.0 + (d8 - d7) / d9);
        double[] dArray2 = new double[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            dArray2[n2] = d7 + (double)n2 * d9;
        }
        n2 = (int)(1.0 + (d11 - d10) / d12);
        double[] dArray3 = new double[n2];
        for (n = 0; n < n2; ++n) {
            dArray3[n] = d10 + (double)n * d12;
        }
        n = n4 * (n4 + 1) / 2 * n2;
        for (int i = 0; i < n3; ++i) {
            DT[][] dTArray2 = SphFuncPICoCalibrationData.getTwoTensorBlock(object, dArray3, dArray2[i], random);
            for (int j = 0; j < n4; ++j) {
                for (int k = 0; k <= j; ++k) {
                    for (int i2 = 0; i2 < n2; ++i2) {
                        int n8 = n2 * (j * (j + 1) / 2) + n2 * k + i2;
                        GaussianMixture gaussianMixture = new GaussianMixture(dTArray2[n8], new double[]{1.0 - dArray3[i2], dArray3[i2]});
                        DataSynthesizer dataSynthesizer = new DataSynthesizer((ModelPDF)gaussianMixture, dW_Scheme, d13, 1, random2);
                        om.output(dataSynthesizer.nextVoxel());
                    }
                }
            }
        }
        FileOutput fileOutput = new FileOutput(string);
        fileOutput.writeString("VERSION\t1.0\n");
        fileOutput.writeString("ROTATION_SEED\t" + n5 + "\n");
        fileOutput.writeString("ONE_DT_BLOCK_SIZE\t" + n7 + "\n");
        fileOutput.writeString("MIN_DT2_ROT_ANGLE\t" + d7 + "\n");
        fileOutput.writeString("MAX_DT2_ROT_ANGLE\t" + d8 + "\n");
        fileOutput.writeString("DT2_ROT_ANGLE_STEP\t" + d9 + "\n");
        fileOutput.writeString("TWO_DT_BLOCK_SIZE\t" + n + "\n");
        fileOutput.writeString("NUM_TWO_DT_BLOCKS\t" + n3 + "\n");
        fileOutput.writeString("DT1_E1_THETA\t0.0\n");
        fileOutput.writeString("DT1_E1_PHI\t0.0\n");
        fileOutput.writeString("DT2_E1_THETA\t1.5707963267948966\n");
        fileOutput.writeString("DT2_E1_PHI\t1.5707963267948966\n");
        fileOutput.writeString("DT2_ROT_AXIS_THETA\t1.5707963267948966\n");
        fileOutput.writeString("DT2_ROT_AXIS_PHI\t0.0\n");
        fileOutput.close();
        om.close();
    }

    public static DT[] getOneTensorBlock(double[] dArray, Random random) {
        int n = dArray.length;
        DT[] dTArray = new DT[n];
        for (int i = 0; i < n; ++i) {
            double[] dArray2 = SphFuncPICoCalibrationData.eigenvalues(dArray[i], trace);
            RealMatrix realMatrix = dt1_e1_e1T.scalarMult(dArray2[0]);
            RealMatrix realMatrix2 = dt1_e2_e2T.scalarMult(dArray2[1]);
            RealMatrix realMatrix3 = dt1_e3_e3T.scalarMult(dArray2[2]);
            double[][] dArray3 = realMatrix.add((RealMatrix)realMatrix2).add((RealMatrix)realMatrix3).entries;
            dTArray[i] = new DT(dArray3[0][0], dArray3[0][1], dArray3[0][2], dArray3[1][1], dArray3[1][2], dArray3[2][2]);
            if (random == null) continue;
            RealMatrix realMatrix4 = Rotations.randomRotMat(random);
            dTArray[i] = dTArray[i].transform(realMatrix4);
        }
        return dTArray;
    }

    public static DT[][] getTwoTensorBlock(double[] dArray, double[] dArray2, double d, Random random) {
        int n;
        RealMatrix realMatrix = Rotations.getRotMat(DT1_E2, d);
        RealMatrix realMatrix2 = realMatrix.transpose();
        RealMatrix realMatrix3 = realMatrix2.product(dt2_e1_e1T).product(realMatrix);
        RealMatrix realMatrix4 = realMatrix2.product(dt2_e2_e2T).product(realMatrix);
        RealMatrix realMatrix5 = realMatrix2.product(dt2_e3_e3T).product(realMatrix);
        DT[][] dTArray = new DT[dArray.length * (dArray.length + 1) / 2 * dArray2.length][2];
        double[][] dArrayArray = new double[dArray.length][];
        for (n = 0; n < dArray.length; ++n) {
            dArrayArray[n] = SphFuncPICoCalibrationData.eigenvalues(dArray[n], trace);
        }
        for (n = 0; n < dArray.length; ++n) {
            RealMatrix realMatrix6 = dt1_e1_e1T.scalarMult(dArrayArray[n][0]);
            RealMatrix realMatrix7 = dt1_e2_e2T.scalarMult(dArrayArray[n][1]);
            RealMatrix realMatrix8 = dt1_e3_e3T.scalarMult(dArrayArray[n][2]);
            double[][] dArray3 = realMatrix6.add((RealMatrix)realMatrix7).add((RealMatrix)realMatrix8).entries;
            DT dT = new DT(dArray3[0][0], dArray3[0][1], dArray3[0][2], dArray3[1][1], dArray3[1][2], dArray3[2][2]);
            for (int i = 0; i <= n; ++i) {
                RealMatrix realMatrix9 = realMatrix3.scalarMult(dArrayArray[i][0]);
                RealMatrix realMatrix10 = realMatrix4.scalarMult(dArrayArray[i][1]);
                RealMatrix realMatrix11 = realMatrix5.scalarMult(dArrayArray[i][2]);
                double[][] dArray4 = realMatrix9.add((RealMatrix)realMatrix10).add((RealMatrix)realMatrix11).entries;
                DT dT2 = new DT(dArray4[0][0], dArray4[0][1], dArray4[0][2], dArray4[1][1], dArray4[1][2], dArray4[2][2]);
                for (int j = 0; j < dArray2.length; ++j) {
                    int n2 = dArray2.length * (n * (n + 1) / 2) + dArray2.length * i + j;
                    dTArray[n2][0] = dT;
                    dTArray[n2][1] = dT2;
                    if (random == null) continue;
                    RealMatrix realMatrix12 = Rotations.randomRotMat(random);
                    dTArray[n2][0] = dTArray[n2][0].transform(realMatrix12);
                    dTArray[n2][1] = dTArray[n2][1].transform(realMatrix12);
                }
            }
        }
        return dTArray;
    }

    public static double[] eigenvalues(double d, double d2) {
        if (d == 0.0) {
            return new double[]{d2 / 3.0, d2 / 3.0, d2 / 3.0};
        }
        if (d > 0.0 && d < 1.0) {
            double d3 = (-3.0 * d2 + 2.0 * d * d * d2 - 2.0 * Math.sqrt(3.0 * d * d * d2 * d2 - 2.0 * d * d * d * d * d2 * d2)) / (3.0 * (-3.0 + 2.0 * d * d));
            double d4 = (d2 - d3) / 2.0;
            return new double[]{d3, d4, d4};
        }
        throw new IllegalArgumentException("Require 0 <= FA < 1");
    }

    static {
        RealMatrix realMatrix = DT1_E1.toRealMatrix();
        RealMatrix realMatrix2 = DT1_E2.toRealMatrix();
        RealMatrix realMatrix3 = DT1_E3.toRealMatrix();
        RealMatrix realMatrix4 = DT2_E1.toRealMatrix();
        RealMatrix realMatrix5 = DT2_E2.toRealMatrix();
        RealMatrix realMatrix6 = DT2_E3.toRealMatrix();
        dt1_e1_e1T = realMatrix.product(realMatrix.transpose());
        dt1_e2_e2T = realMatrix2.product(realMatrix2.transpose());
        dt1_e3_e3T = realMatrix3.product(realMatrix3.transpose());
        dt2_e1_e1T = realMatrix4.product(realMatrix4.transpose());
        dt2_e2_e2T = realMatrix5.product(realMatrix5.transpose());
        dt2_e3_e3T = realMatrix6.product(realMatrix6.transpose());
        trace = 2.1E-9;
    }
}

