/*
 * Decompiled with CFR 0.152.
 */
package apps;

import apps.Executable;
import apps.PointSetToScheme;
import data.OutputManager;
import imaging.DW_Scheme;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Random;
import java.util.Scanner;
import java.util.logging.Logger;
import misc.LoggedException;
import misc.OrderedAcqMinimizer;
import misc.SphericalPoints;
import numerics.MTRandom;
import tools.ArrayOps;
import tools.CL_Initializer;
import tools.FileOutput;

public class SubsetScheme
extends Executable {
    private static final Logger logger = Logger.getLogger("apps/SubsetScheme");
    int fullSetSize;
    double[][] fullSetPoints;
    int numSubsets;
    int[] subsetSizes;
    double[][][] subsetPoints;
    int fullMeas;
    String imageListFile;
    String[] imageList;
    String outputRoot;
    String subsetFile;

    public SubsetScheme(String[] stringArray) {
        super(stringArray);
    }

    @Override
    public void initDefaultVals() {
        this.fullSetSize = 0;
        this.fullSetPoints = null;
        this.numSubsets = 0;
        this.subsetSizes = null;
        this.subsetPoints = null;
        this.fullMeas = 0;
        this.imageListFile = null;
        this.imageList = null;
        this.outputRoot = "subset";
        this.subsetFile = null;
    }

    @Override
    public void initOptions(String[] stringArray) {
        if (stringArray.length == 0) {
            System.err.println("SubsetScheme -schemefile <schemefile> -subsetpoints <points> [-imagelist <list> -outputroot <root>]");
            System.exit(0);
        }
        CL_Initializer.CL_init(stringArray);
        CL_Initializer.initImagingScheme();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-subsetpoints")) {
                this.subsetFile = stringArray[i + 1];
                CL_Initializer.markAsParsed(i, 2);
            }
            if (stringArray[i].equals("-imagelist")) {
                this.imageListFile = stringArray[i + 1];
                CL_Initializer.markAsParsed(i, 2);
            }
            if (!stringArray[i].equals("-outputroot")) continue;
            this.outputRoot = stringArray[i + 1];
            CL_Initializer.markAsParsed(i, 2);
        }
        CL_Initializer.checkParsing(stringArray);
    }

    @Override
    public void initVariables() {
        this.fullMeas = CL_Initializer.imPars.numMeasurements();
        this.fullSetPoints = CL_Initializer.imPars.getNonZeroG_Dirs();
        this.fullSetSize = this.fullSetPoints.length;
    }

    @Override
    public void execute(OutputManager outputManager) {
        int n;
        int n2;
        Scanner scanner;
        try {
            scanner = new Scanner(new File(this.subsetFile)).useDelimiter("\\s+");
            n2 = scanner.nextInt();
            if (this.fullSetSize != n2) {
                throw new LoggedException("Full scheme has " + this.fullSetSize + " non-zero g, but " + "subset is from a set of " + n2 + " points");
            }
            this.numSubsets = scanner.nextInt();
            this.subsetSizes = new int[this.numSubsets];
            for (int i = 0; i < this.numSubsets; ++i) {
                this.subsetSizes[i] = scanner.nextInt();
            }
            double[][] dArray = PointSetToScheme.readPoints(this.subsetFile, false, false, false);
            int n3 = 0;
            this.subsetPoints = new double[this.numSubsets][][];
            for (n = 0; n < this.numSubsets; ++n) {
                this.subsetPoints[n] = new double[this.subsetSizes[n]][];
                for (int i = 0; i < this.subsetSizes[n]; ++i) {
                    this.subsetPoints[n][i] = dArray[n3++];
                }
            }
        }
        catch (IOException iOException) {
            throw new LoggedException(iOException);
        }
        if (this.imageListFile != null) {
            try {
                scanner = new Scanner(new File(this.imageListFile));
                scanner.useDelimiter("\\n");
                this.imageList = new String[this.fullMeas];
                for (n2 = 0; n2 < this.fullMeas; ++n2) {
                    this.imageList[n2] = scanner.next();
                }
            }
            catch (IOException iOException) {
                logger.warning("Can't process image list " + this.imageListFile + ", image list will " + "not be written");
                this.imageList = null;
            }
        }
        for (int i = 0; i < this.numSubsets; ++i) {
            int n4;
            int n5;
            n2 = CL_Initializer.imPars.numZeroMeasurements();
            int n6 = this.subsetSizes[i] + n2;
            int[] nArray = new int[n6];
            n = 0;
            for (n5 = 0; n5 < this.fullMeas; ++n5) {
                if (!CL_Initializer.imPars.zero(n5)) continue;
                nArray[n++] = n5;
            }
            for (n5 = 0; n5 < this.subsetSizes[i]; ++n5) {
                int n7 = 0;
                double d = 0.0;
                for (int j = 0; j < this.fullMeas; ++j) {
                    double[] dArray = CL_Initializer.imPars.getG_Dir(j);
                    double d2 = dArray[0] * this.subsetPoints[i][n5][0] + dArray[1] * this.subsetPoints[i][n5][1] + dArray[2] * this.subsetPoints[i][n5][2];
                    if (!(d2 > d)) continue;
                    n7 = j;
                    d = d2;
                }
                if (d < 0.99984769516) {
                    logger.warning("Couldn't match point " + n5 + " in subset " + i + " to a scheme direction within 1 degree. Closest angle was " + Math.acos(d) * 180.0 / Math.PI);
                }
                nArray[n++] = n7;
            }
            if (n != nArray.length) {
                throw new LoggedException("Could not match all points in subset to points in the full set");
            }
            DW_Scheme dW_Scheme = CL_Initializer.imPars.getSubsetScheme(nArray);
            FileOutput fileOutput = new FileOutput(this.outputRoot + "_" + i + ".scheme");
            fileOutput.writeString(dW_Scheme.toString());
            fileOutput.close();
            fileOutput = new FileOutput(this.outputRoot + "_" + i + ".indices");
            for (n4 = 0; n4 < n6; ++n4) {
                fileOutput.writeString(nArray[n4] + "\n");
            }
            fileOutput.close();
            if (this.imageList != null) {
                fileOutput = new FileOutput(this.outputRoot + "_" + i + ".imagelist");
                for (n4 = 0; n4 < n6; ++n4) {
                    fileOutput.writeString(this.imageList[nArray[n4]] + "\n");
                }
                fileOutput.close();
            }
            DecimalFormat decimalFormat = new DecimalFormat("0.000");
            double[][] dArray = SphericalPoints.getElecPointSet(this.subsetSizes[i]);
            double[] dArray2 = SubsetScheme.getRandomSubsetEnergy(this.fullSetPoints, this.subsetSizes[i], 100, new MTRandom(CL_Initializer.seed));
            double d = ArrayOps.mean(dArray2);
            double d3 = ArrayOps.median(dArray2);
            System.out.println("Energy of subset " + i + "\t\t" + decimalFormat.format(SubsetScheme.pointsetEnergy(this.subsetPoints[i])));
            System.out.println("Energy of optimal " + this.subsetSizes[i] + "-point set\t" + decimalFormat.format(SubsetScheme.pointsetEnergy(dArray)));
            System.out.println("Mean energy of random subset\t" + decimalFormat.format(d));
            System.out.println("Median energy of random subset\t" + decimalFormat.format(d3));
            System.out.println();
        }
    }

    public static double[][] getRandomSubset(double[][] dArray, int n, Random random) {
        int n2;
        int n3 = dArray.length;
        boolean[] blArray = new boolean[n3];
        int n4 = 0;
        while (n4 < n) {
            n2 = random.nextInt(n3);
            if (blArray[n2]) continue;
            blArray[n2] = true;
            ++n4;
        }
        n2 = 0;
        double[][] dArray2 = new double[n][3];
        for (int i = 0; i < n3; ++i) {
            if (!blArray[i]) continue;
            dArray2[n2][0] = dArray[i][0];
            dArray2[n2][1] = dArray[i][1];
            dArray2[n2][2] = dArray[i][2];
            ++n2;
        }
        return dArray2;
    }

    public static double[] getRandomSubsetEnergy(double[][] dArray, int n, int n2, Random random) {
        double[] dArray2 = new double[n2];
        for (int i = 0; i < n2; ++i) {
            double[][] dArray3 = SubsetScheme.getRandomSubset(dArray, n, random);
            dArray2[i] = SubsetScheme.pointsetEnergy(dArray3);
        }
        return dArray2;
    }

    public static double pointsetEnergy(double[][] dArray) {
        double[][] dArray2 = OrderedAcqMinimizer.pairEnergyMatrix(dArray);
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < i; ++j) {
                d += dArray2[i][j];
            }
        }
        return d;
    }
}

