/*
 * Decompiled with CFR 0.152.
 */
package apps;

import apps.ProcessStreamlines;
import data.OutputManager;
import imaging.ImageHeader;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Locale;
import misc.LoggedException;
import tools.CL_Initializer;
import tools.FileOutput;
import tractography.Voxel;
import tractography.VoxelROI;

public class TargetProbsToASCII {
    private static int minTargetIndex = 0;
    private static int maxTargetIndex = 0;
    private static int[] targetIndices = null;
    private static boolean[] targetExists = null;

    public static void main(String[] stringArray) {
        Object object;
        Locale.setDefault(Locale.UK);
        String string = null;
        String string2 = null;
        String string3 = null;
        int n = 1;
        int n2 = 1;
        CL_Initializer.CL_init(stringArray);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-inputroot")) {
                string = stringArray[i + 1];
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-targetfile")) {
                string2 = stringArray[i + 1];
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-seedfile")) {
                string3 = stringArray[i + 1];
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-pd")) {
                n2 = Integer.parseInt(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (!stringArray[i].equals("-regionindex")) continue;
            n = Integer.parseInt(stringArray[i + 1]);
            CL_Initializer.markAsParsed(i, 2);
        }
        CL_Initializer.checkParsing(stringArray);
        CL_Initializer.headerTemplateFile = string3;
        CL_Initializer.initInputSpaceAndHeaderOptions();
        ImageHeader imageHeader = null;
        String string4 = null;
        string4 = string3.endsWith(".gz") ? string3.substring(string3.length() - 7) : string3.substring(string3.length() - 4);
        try {
            imageHeader = ImageHeader.readHeader(string3);
        }
        catch (IOException iOException) {
            throw new LoggedException("Cannot read header of seed file");
        }
        int n3 = imageHeader.xDataDim();
        int n4 = imageHeader.yDataDim();
        int n5 = imageHeader.zDataDim();
        double d = Math.abs(imageHeader.xVoxelDim());
        double d2 = Math.abs(imageHeader.yVoxelDim());
        double d3 = Math.abs(imageHeader.zVoxelDim());
        int[][][] nArray = ProcessStreamlines.readIntVolume(string3);
        string = string + Integer.toString(n) + "_";
        double[][][] dArray = null;
        try {
            dArray = ImageHeader.readHeader(string2).readSingleVolumeData();
        }
        catch (IOException iOException) {
            throw new LoggedException("Cannot read header of target file");
        }
        TargetProbsToASCII.setTargetIndices(dArray);
        VoxelROI voxelROI = new VoxelROI(string3, imageHeader);
        Voxel[] voxelArray = voxelROI.getRegion(n).getSeedVoxels(d, d2, d3);
        String string5 = "";
        int n6 = 6;
        for (int i = 0; i < n6; ++i) {
            string5 = string5 + "0";
        }
        DecimalFormat decimalFormat = new DecimalFormat("0." + string5 + "E00;-0." + string5 + "E00");
        StringBuffer stringBuffer = new StringBuffer();
        int n7 = 1;
        String string6 = string + n7 + "_" + n2;
        while (new File(string6 + string4).exists()) {
            int n8;
            object = new double[maxTargetIndex - minTargetIndex + 1];
            double[][][] dArray2 = null;
            try {
                dArray2 = ImageHeader.readHeader(string6 + string4).readSingleVolumeData();
            }
            catch (IOException iOException) {
                throw new LoggedException("Cannot read header " + string6 + string4);
            }
            for (int i = 0; i < n5; ++i) {
                for (n8 = 0; n8 < n4; ++n8) {
                    for (int j = 0; j < n3; ++j) {
                        if (!(dArray2[j][n8][i] > 0.0)) continue;
                        object[TargetProbsToASCII.targetIndices[(int)dArray[j][n8][i]]] = dArray2[j][n8][i];
                    }
                }
            }
            String string7 = "\t";
            stringBuffer.append(voxelArray[n7 - 1].x + string7 + voxelArray[n7 - 1].y + string7 + voxelArray[n7 - 1].z + string7);
            for (n8 = minTargetIndex; n8 <= maxTargetIndex; ++n8) {
                if (!targetExists[n8]) continue;
                stringBuffer.append(decimalFormat.format((double)object[targetIndices[n8]]));
                if (n8 >= maxTargetIndex) continue;
                stringBuffer.append(string7);
            }
            stringBuffer.append("\n");
            string6 = string + ++n7 + "_" + n2;
        }
        if (OutputManager.outputFile != null) {
            object = new FileOutput(OutputManager.outputFile);
            ((FileOutput)object).writeString(stringBuffer.toString());
            ((FileOutput)object).close();
        } else {
            System.out.print(stringBuffer.toString());
        }
    }

    private static void setTargetIndices(double[][][] dArray) {
        int n;
        int n2;
        int n3 = Short.MAX_VALUE;
        int n4 = 0;
        int n5 = dArray.length;
        int n6 = dArray[0].length;
        int n7 = dArray[0][0].length;
        targetExists = new boolean[Short.MAX_VALUE];
        for (n2 = 0; n2 < n7; ++n2) {
            for (n = 0; n < n6; ++n) {
                for (int i = 0; i < n5; ++i) {
                    if (dArray[i][n][n2] < (double)n3 && dArray[i][n][n2] > 0.0) {
                        n3 = (short)dArray[i][n][n2];
                    } else if (dArray[i][n][n2] > (double)n4) {
                        n4 = (short)dArray[i][n][n2];
                    }
                    if (!(dArray[i][n][n2] > 0.0)) continue;
                    TargetProbsToASCII.targetExists[(short)((int)dArray[i][n][n2])] = true;
                }
            }
        }
        minTargetIndex = n3;
        maxTargetIndex = n4;
        n2 = 0;
        targetIndices = new int[maxTargetIndex + 1];
        for (n = minTargetIndex; n <= maxTargetIndex; ++n) {
            if (!targetExists[n]) continue;
            TargetProbsToASCII.targetIndices[n] = n2++;
        }
    }
}

