/*
 * Decompiled with CFR 0.152.
 */
package apps;

import data.OutputManager;
import imaging.ImageHeader;
import java.io.IOException;
import misc.LoggedException;
import misc.ScalarImage;
import tools.CL_Initializer;
import tractography.Tract;
import tractography.TractSource;
import tractography.TractStatisticFilter;
import tractography.TractStatisticImage;

public class TractStatistics {
    public static void main(String[] stringArray) {
        boolean bl = false;
        String string = null;
        CL_Initializer.inputModel = "raw";
        CL_Initializer.CL_init(stringArray);
        String string2 = "tractstats";
        boolean bl2 = false;
        boolean bl3 = false;
        String string3 = "mean";
        String string4 = "mean";
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-scalarfile")) {
                string = stringArray[i + 1];
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-countintersect")) {
                bl2 = true;
                CL_Initializer.markAsParsed(i);
                continue;
            }
            if (stringArray[i].equals("-interpolate")) {
                bl3 = true;
                CL_Initializer.markAsParsed(i);
                continue;
            }
            if (stringArray[i].equals("-tractstat")) {
                string3 = stringArray[i + 1];
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-imagestat")) {
                string4 = stringArray[i + 1];
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-outputroot")) {
                string2 = stringArray[i + 1];
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (!stringArray[i].equals("-outputimage")) continue;
            bl = true;
            CL_Initializer.markAsParsed(i);
        }
        CL_Initializer.checkParsing(stringArray);
        if (bl && string3.equals("none")) {
            throw new LoggedException("Tract statistic must be specified when an image is to be generated.");
        }
        ImageHeader imageHeader = null;
        try {
            Object object;
            ScalarImage scalarImage = null;
            if (string != null) {
                CL_Initializer.headerTemplateFile = string;
                imageHeader = ImageHeader.readHeader(string);
                object = imageHeader.readSingleVolumeData();
                scalarImage = new ScalarImage((double[][][])object, imageHeader.getVoxelDims());
            }
            CL_Initializer.initInputSpaceAndHeaderOptions();
            object = new TractSource(CL_Initializer.inputFile, CL_Initializer.headerTemplate);
            if (bl) {
                Object object2;
                TractStatisticImage tractStatisticImage = null;
                tractStatisticImage = scalarImage != null ? new TractStatisticImage(scalarImage) : new TractStatisticImage(CL_Initializer.dataDims, CL_Initializer.voxelDims);
                tractStatisticImage.setTractStatistic(string3);
                tractStatisticImage.setImageStatistic(string4);
                tractStatisticImage.setInterpolate(bl3);
                tractStatisticImage.setCountIntersect(bl2);
                while (((TractSource)object).more()) {
                    object2 = ((TractSource)object).nextTract();
                    tractStatisticImage.processTract((Tract)object2);
                }
                object2 = tractStatisticImage.getImageStatistic();
                CL_Initializer.headerTemplate.writeScalarImage((double[][][])object2, string2);
            } else {
                OutputManager outputManager = new OutputManager();
                TractStatisticFilter tractStatisticFilter = null;
                tractStatisticFilter = scalarImage != null ? new TractStatisticFilter(scalarImage) : new TractStatisticFilter(CL_Initializer.dataDims, CL_Initializer.voxelDims);
                tractStatisticFilter.setTractStatistic(string3);
                tractStatisticFilter.setInterpolate(bl3);
                while (((TractSource)object).more()) {
                    Tract tract = ((TractSource)object).nextTract();
                    outputManager.output(tractStatisticFilter.processTract(tract));
                }
                outputManager.close();
            }
        }
        catch (IOException iOException) {
            throw new LoggedException(iOException);
        }
    }
}

