/*
 * Decompiled with CFR 0.152.
 */
package apps;

import apps.Executable;
import data.OutputManager;
import data.VoxelOrderDataSource;
import imaging.ImageHeader;
import java.text.DecimalFormat;
import java.util.logging.Logger;
import tools.CL_Initializer;

public class VoxelToImage
extends Executable {
    private String outputRoot;
    private int components;
    private ImageHeader header;
    private int xDataDim;
    private int yDataDim;
    private int zDataDim;
    private static Logger logger = Logger.getLogger("camino.apps.VoxelToImage");

    public VoxelToImage(String[] stringArray) {
        super(stringArray);
    }

    @Override
    public void initDefaultVals() {
        this.outputRoot = "voxel2image";
        this.components = 1;
        this.header = null;
        this.xDataDim = 0;
        this.yDataDim = 0;
        this.zDataDim = 0;
    }

    @Override
    public void initOptions(String[] stringArray) {
        CL_Initializer.inputDataType = "double";
        OutputManager.outputDataType = "float";
        CL_Initializer.CL_init(stringArray);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-outputroot")) {
                this.outputRoot = stringArray[i + 1];
                CL_Initializer.markAsParsed(i, 2);
            }
            if (stringArray[i].equals("-components")) {
                this.components = Integer.parseInt(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
            }
            if (!stringArray[i].equals("-header")) continue;
            CL_Initializer.headerTemplateFile = stringArray[i + 1];
            CL_Initializer.markAsParsed(i, 2);
        }
        CL_Initializer.checkParsing(stringArray);
        CL_Initializer.initInputSpaceAndHeaderOptions();
        this.header = CL_Initializer.headerTemplate;
        this.xDataDim = this.header.xDataDim();
        this.yDataDim = this.header.yDataDim();
        this.zDataDim = this.header.zDataDim();
    }

    @Override
    public void initVariables() {
    }

    @Override
    public void execute(OutputManager outputManager) {
        int n;
        VoxelOrderDataSource voxelOrderDataSource = new VoxelOrderDataSource(CL_Initializer.inputFile, this.components, CL_Initializer.inputDataType);
        double[][][][] dArray = new double[this.components][this.xDataDim][this.yDataDim][this.zDataDim];
        for (int i = 0; i < this.zDataDim; ++i) {
            for (n = 0; n < this.yDataDim; ++n) {
                for (int j = 0; j < this.xDataDim; ++j) {
                    double[] dArray2 = voxelOrderDataSource.nextVoxel();
                    for (int k = 0; k < this.components; ++k) {
                        dArray[k][j][n][i] = dArray2[k];
                    }
                }
            }
        }
        DecimalFormat decimalFormat = new DecimalFormat("0000");
        for (n = 0; n < this.components; ++n) {
            String string = this.outputRoot;
            if (this.components > 1) {
                string = this.outputRoot + decimalFormat.format(n + 1);
            }
            this.header.writeScalarImage(dArray[n], string);
        }
    }
}

