/*
 * Decompiled with CFR 0.152.
 */
package data;

import data.GaussianMixture;
import data.ModelPDF;
import misc.DT;

public class BallStick
implements ModelPDF {
    private double[] orientation;
    private double diffusivity;
    private double volfrac;
    private GaussianMixture gm;
    private DT[] dt;

    public BallStick(double d, double d2, double[] dArray) {
        this.orientation = dArray;
        this.volfrac = d2;
        this.diffusivity = d;
        this.dt = new DT[2];
    }

    @Override
    public double at(double[] dArray, double d) {
        if (this.gm == null) {
            this.makeGaussianMix();
        }
        return this.gm.at(dArray, d);
    }

    @Override
    public double ftAt(double[] dArray, double d) {
        if (this.gm == null) {
            this.makeGaussianMix();
        }
        return this.gm.ftAt(dArray, d);
    }

    @Override
    public double ftAtB_Vec(double[] dArray, double d) {
        if (this.gm == null) {
            this.makeGaussianMix();
        }
        return this.gm.ftAt(dArray, d);
    }

    private void makeGaussianMix() {
        this.dt[0] = new DT(this.diffusivity, 0.0, 0.0, this.diffusivity, 0.0, this.diffusivity);
        this.dt[1] = new DT(this.diffusivity * this.orientation[0] * this.orientation[0], this.diffusivity * this.orientation[0] * this.orientation[1], this.diffusivity * this.orientation[0] * this.orientation[2], this.diffusivity * this.orientation[1] * this.orientation[1], this.diffusivity * this.orientation[1] * this.orientation[2], this.diffusivity * this.orientation[2] * this.orientation[2]);
        double[] dArray = new double[]{1.0 - this.volfrac, this.volfrac};
        this.gm = new GaussianMixture(this.dt, dArray);
    }

    @Override
    public double[][] getPDs() {
        double[][] dArray = new double[this.dt.length][3];
        for (int i = 0; i < this.dt.length; ++i) {
            double[] dArray2 = this.dt[i].getPD();
            for (int j = 0; j < 3; ++j) {
                dArray[i][j] = dArray2[j];
            }
        }
        return dArray;
    }

    public double[] getInformationArray() {
        double[] dArray = new double[]{this.diffusivity, this.volfrac, this.orientation[0], this.orientation[1], this.orientation[2]};
        return dArray;
    }
}

