/*
 * Decompiled with CFR 0.152.
 */
package data;

import data.DataSource;
import data.DataSourceException;
import data.DataSynthesizer;
import data.ModelPDF;
import imaging.DW_Scheme;
import java.util.Random;
import numerics.MTRandom;

public class SyntheticBootstrapper
implements DataSource {
    protected DataSynthesizer dataSynth;
    protected double[][] repeatedMeasurements;
    protected int numVoxels = -1;
    protected int voxelNum;
    protected Random r;

    public SyntheticBootstrapper(ModelPDF modelPDF, DW_Scheme dW_Scheme, double d, int n, int n2) {
        this.init(modelPDF, dW_Scheme, d, n, n2, new MTRandom(12345L));
    }

    public SyntheticBootstrapper(ModelPDF modelPDF, DW_Scheme dW_Scheme, double d, int n, int n2, int n3) {
        this.init(modelPDF, dW_Scheme, d, n, n2, new MTRandom(n3));
    }

    public SyntheticBootstrapper(ModelPDF modelPDF, DW_Scheme dW_Scheme, double d, int n, int n2, Random random) {
        this.init(modelPDF, dW_Scheme, d, n, n2, random);
    }

    protected void init(ModelPDF modelPDF, DW_Scheme dW_Scheme, double d, int n, int n2, Random random) {
        this.r = random;
        this.dataSynth = new DataSynthesizer(modelPDF, dW_Scheme, d, n, this.r);
        int n3 = dW_Scheme.numMeasurements();
        this.repeatedMeasurements = new double[n3][n];
        for (int i = 0; i < n; ++i) {
            try {
                double[] dArray = this.dataSynth.nextVoxel();
                for (int j = 0; j < n3; ++j) {
                    this.repeatedMeasurements[j][i] = dArray[j];
                }
                continue;
            }
            catch (Exception exception) {
                System.err.println("Error in initialization of SyntheticBootstrapper.");
                throw new RuntimeException(exception);
            }
        }
        this.numVoxels = n2;
        this.voxelNum = 1;
    }

    @Override
    public double[] nextVoxel() throws DataSourceException {
        if (this.numVoxels >= 0 && this.voxelNum > this.numVoxels) {
            throw new DataSourceException("Exceeded the specified number of voxels.");
        }
        ++this.voxelNum;
        int n = this.repeatedMeasurements.length;
        int n2 = this.repeatedMeasurements[0].length;
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            int n3 = this.r.nextInt(n2);
            dArray[i] = this.repeatedMeasurements[i][n3];
        }
        return dArray;
    }

    @Override
    public boolean more() {
        return this.numVoxels >= 0 && this.voxelNum <= this.numVoxels;
    }
}

