/*
 * Decompiled with CFR 0.152.
 */
package data;

import data.DataSource;
import data.DataSourceException;
import imaging.DW_Scheme;
import java.util.Random;
import misc.LoggedException;
import numerics.MTRandom;
import numerics.RealMatrix;

public abstract class WildBootstrapDataSynth
implements DataSource {
    private final DataSource rawDataSource;
    private final int samples;
    private int components;
    private int samplesGenerated = 0;
    private double alpha = -1.0;
    private final Random ran;
    private boolean logData = false;
    private boolean normalizeData = false;
    private RealMatrix epsilon;
    private double[] weightedResiduals;
    private RealMatrix mu;
    private double meanS0;
    protected RealMatrix H;
    protected RealMatrix X;
    protected RealMatrix linearInv;
    private boolean reachedEndOfFile;
    private boolean noMoreData;
    protected DW_Scheme ip;
    private boolean[] zero;
    private int numMeas;

    public WildBootstrapDataSynth(DataSource dataSource, DW_Scheme dW_Scheme, int n) {
        this(dataSource, dW_Scheme, n, new MTRandom(2350L));
    }

    public WildBootstrapDataSynth(DataSource dataSource, DW_Scheme dW_Scheme, int n, int n2) {
        this(dataSource, dW_Scheme, n, new MTRandom(n2));
    }

    public WildBootstrapDataSynth(DataSource dataSource, DW_Scheme dW_Scheme, int n, Random random) {
        this.rawDataSource = dataSource;
        this.ip = dW_Scheme;
        this.components = this.numMeas = this.ip.numMeasurements();
        this.zero = new boolean[this.numMeas];
        this.meanS0 = 0.0;
        this.samples = n;
        this.ran = random;
    }

    protected void init() {
        this.reachedEndOfFile = false;
        this.initializeReconSpecificParams();
        for (int i = 0; i < this.numMeas; ++i) {
            if (!this.ip.zero(i)) continue;
            this.zero[i] = true;
        }
        if (this.rawDataSource != null) {
            try {
                this.getNextSourceVoxel();
            }
            catch (DataSourceException dataSourceException) {
                throw new LoggedException(dataSourceException);
            }
        } else {
            this.noMoreData = true;
        }
    }

    protected abstract void initializeReconSpecificParams();

    @Override
    public final double[] nextVoxel() {
        if (this.noMoreData) {
            throw new DataSourceException("No more voxels in data source.");
        }
        double[] dArray = this.getBootstrapSample();
        if (this.samples > -1) {
            ++this.samplesGenerated;
        }
        if (this.samplesGenerated == this.samples) {
            if (this.reachedEndOfFile || this.rawDataSource == null) {
                this.noMoreData = true;
            } else {
                this.getNextSourceVoxel();
            }
        }
        return dArray;
    }

    private double[] getBootstrapSample() {
        double[] dArray = new double[this.components];
        for (int i = 0; i < this.components; ++i) {
            double d = this.ran.nextBoolean() ? 1.0 : -1.0;
            dArray[i] = this.mu.entries[i][0] + d * this.weightedResiduals[i];
            if (!this.logData) continue;
            dArray[i] = Math.exp(dArray[i]);
        }
        if (this.normalizeData) {
            return this.unNormalizeData(dArray, this.meanS0);
        }
        return dArray;
    }

    @Override
    public boolean more() {
        return !this.noMoreData;
    }

    private void getNextSourceVoxel() {
        if (this.reachedEndOfFile) {
            this.noMoreData = true;
            throw new DataSourceException("No more voxels in data source.");
        }
        double[][] dArrayArray = new double[][]{this.rawDataSource.nextVoxel()};
        this.setSourceData(dArrayArray);
        if (!this.rawDataSource.more()) {
            this.reachedEndOfFile = true;
        }
    }

    public void setSourceData(float[] fArray) {
        double[][] dArray = new double[1][fArray.length];
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            dArray[0][i] = fArray[i];
        }
        this.setSourceData(dArray);
    }

    public void setSourceData(double[] dArray) {
        double[][] dArray2 = new double[1][dArray.length];
        System.arraycopy(dArray, 0, dArray2[0], 0, dArray.length);
        this.setSourceData(dArray2);
    }

    private void setSourceData(double[][] dArray) {
        this.noMoreData = false;
        this.samplesGenerated = 0;
        double d = this.ip.geoMeanZeroMeas(dArray[0]);
        if (d == 0.0) {
            d = 1.0;
        }
        if (this.normalizeData) {
            dArray[0] = this.ip.normalizeData(dArray[0], d);
        }
        if (this.logData) {
            dArray[0] = this.getLogData(dArray[0]);
        }
        RealMatrix realMatrix = new RealMatrix(dArray).transpose();
        RealMatrix realMatrix2 = this.linearInv.product(realMatrix);
        this.mu = this.X.product(realMatrix2);
        this.epsilon = realMatrix.sub(this.mu);
        this.calculateWeightedResiduals();
    }

    private void calculateWeightedResiduals() {
        this.weightedResiduals = new double[this.components];
        for (int i = 0; i < this.components; ++i) {
            this.weightedResiduals[i] = this.epsilon.entries[i][0] / Math.pow(1.0 - this.H.entries[i][i], this.alpha);
        }
    }

    private double[] getLogData(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = dArray[i] > 0.0 ? Math.log(dArray[i]) : 0.0;
        }
        return dArray2;
    }

    private double[] unNormalizeData(double[] dArray, double d) {
        double[] dArray2 = new double[this.numMeas];
        int n = 0;
        for (int i = 0; i < this.numMeas; ++i) {
            dArray2[i] = this.zero[i] ? d : d * dArray[n++];
        }
        return dArray2;
    }

    protected void useLogData() {
        this.logData = true;
    }

    protected void useNormalizedData() {
        this.normalizeData = true;
        this.components = this.ip.numMeasurements() - this.ip.numZeroMeasurements();
    }

    public void setHC2() {
        this.alpha = -0.5;
        this.calculateWeightedResiduals();
    }

    public void setHC3() {
        this.alpha = -1.0;
        this.calculateWeightedResiduals();
    }
}

