/*
 * Decompiled with CFR 0.152.
 */
package fitters;

import data.OutputManager;
import fitters.BallStickLM_GaussianFitter;
import fitters.BallStickMultiRunLM_GaussianFitter;
import fitters.Codec;
import fitters.CompartmentFitter;
import fitters.FitModel;
import fitters.NoiseModel;
import imaging.DW_Scheme;
import misc.LoggedException;
import models.compartments.CompartmentModel;
import optimizers.LM_Minimizer;
import optimizers.MinimizerException;
import optimizers.MultiRunMinimizer;
import tools.CL_Initializer;

public class BallStickDotLM_Fitter
extends CompartmentFitter {
    protected BallStickLM_GaussianFitter bsfitter;
    private final int numModelParams = 8;
    private final int numOptParams = 6;

    public BallStickDotLM_Fitter() {
    }

    public BallStickDotLM_Fitter(DW_Scheme dW_Scheme) {
        this(dW_Scheme, FitModel.getCompartmentList(CL_Initializer.fitModel), FitModel.getCompartmentModelParams(CL_Initializer.fitModel));
    }

    public BallStickDotLM_Fitter(DW_Scheme dW_Scheme, String[] stringArray, double[] dArray) {
        this.scheme = dW_Scheme;
        this.makeCodec();
        this.cm = new CompartmentModel(stringArray, dArray);
        try {
            this.initLM_Minimizer(NoiseModel.getNoiseModel(CL_Initializer.noiseModel));
            LM_Minimizer cfr_ignored_0 = (LM_Minimizer)this.minimizer;
            LM_Minimizer.setCONVERGETHRESH(1.0E-8);
            LM_Minimizer cfr_ignored_1 = (LM_Minimizer)this.minimizer;
            LM_Minimizer.setMAXITER(5000);
        }
        catch (Exception exception) {
            throw new LoggedException(exception);
        }
        this.bsfitter = new BallStickMultiRunLM_GaussianFitter(dW_Scheme, 3, 0);
    }

    protected void makeCodec() {
        this.cod = new Codec(){

            @Override
            public double[] modelToOpt(double[] dArray) {
                double[] dArray2 = new double[]{Math.sqrt(dArray[0]), Math.acos(Math.sqrt(dArray[1])), Math.acos(Math.sqrt(dArray[2] / (1.0 - dArray[1]))), Math.sqrt(dArray[4]), dArray[5], dArray[6]};
                return dArray2;
            }

            @Override
            public double[] optToModel(double[] dArray) {
                double d;
                double[] dArray2 = new double[8];
                dArray2[0] = dArray[0] * dArray[0];
                double d2 = Math.cos(dArray[1]);
                d2 *= d2;
                dArray2[1] = d2;
                dArray2[2] = d = Math.cos(dArray[2]) * Math.cos(dArray[2]) * (1.0 - d2);
                dArray2[3] = 1.0 - d2 - d;
                dArray2[4] = dArray[3] * dArray[3];
                dArray2[5] = dArray[4];
                dArray2[6] = dArray[5];
                dArray2[7] = dArray2[4];
                return dArray2;
            }

            @Override
            public int getNumOptParams() {
                return 6;
            }

            @Override
            public int getNumModelParams() {
                return 8;
            }

            @Override
            public int getDirectionIndex() {
                return 5;
            }
        };
    }

    @Override
    protected double[] getStartPoint(double[] dArray) {
        double[] dArray2;
        double[] dArray3;
        if (this.getFixedStartPoint(dArray) != null) {
            return this.getFixedStartPoint(dArray);
        }
        try {
            dArray3 = MultiRunMinimizer.getBestSolution(this.bsfitter.fit(dArray));
        }
        catch (MinimizerException minimizerException) {
            dArray3 = this.bsfitter.getStartPoint(dArray);
            minimizerException.printStackTrace();
        }
        double d = dArray3[1];
        double d2 = dArray3[2] - 5.0E-5;
        double d3 = dArray3[3] - 5.0E-5;
        double d4 = 1.0E-4;
        double d5 = dArray3[5];
        double d6 = dArray3[6];
        double d7 = dArray3[4];
        dArray2 = new double[]{d, d2, d3, d4, d7, d5, d6, dArray2[4]};
        return dArray2;
    }

    public static void main(String[] stringArray) {
        CL_Initializer.CL_init(stringArray);
        CL_Initializer.checkParsing(stringArray);
        CL_Initializer.initImagingScheme();
        CL_Initializer.initDataSynthesizer();
        OutputManager outputManager = new OutputManager();
        BallStickDotLM_Fitter ballStickDotLM_Fitter = new BallStickDotLM_Fitter(CL_Initializer.imPars);
        while (CL_Initializer.data.more()) {
            try {
                double[] dArray = CL_Initializer.data.nextVoxel();
                double[][] dArray2 = ballStickDotLM_Fitter.fit(dArray);
                outputManager.output(dArray2[0]);
            }
            catch (Exception exception) {
                System.err.println(exception);
            }
        }
        outputManager.close();
    }
}

