/*
 * Decompiled with CFR 0.152.
 */
package fitters;

import data.OutputManager;
import fitters.Codec;
import fitters.FitModel;
import fitters.MCMC_Fitter;
import fitters.Perturbation;
import fitters.Prior;
import imaging.DW_Scheme;
import inverters.LinearDT_Inversion;
import java.util.Random;
import java.util.logging.Logger;
import misc.DT;
import numerics.Vector3D;
import tools.CL_Initializer;

public class BallStickMCMC_Fitter
extends MCMC_Fitter {
    private static Logger logger = Logger.getLogger("camino.fitters.BallStickMCMC_Fitter");
    protected LinearDT_Inversion dtfitter;
    private final int numModelParams = 7;
    private final int numOptParams = 5;

    public BallStickMCMC_Fitter() {
    }

    public BallStickMCMC_Fitter(DW_Scheme dW_Scheme) {
        this(dW_Scheme, FitModel.getCompartmentList(CL_Initializer.fitModel), FitModel.getCompartmentModelParams(CL_Initializer.fitModel));
    }

    public BallStickMCMC_Fitter(DW_Scheme dW_Scheme, String[] stringArray, double[] dArray) {
        super(dW_Scheme, stringArray, dArray);
        this.dtfitter = new LinearDT_Inversion(dW_Scheme);
    }

    @Override
    protected void makeCodec() {
        this.cod = new Codec(){

            @Override
            public double[] modelToOpt(double[] dArray) {
                double[] dArray2 = new double[]{dArray[0], dArray[1], dArray[3], dArray[4], dArray[5]};
                return dArray2;
            }

            @Override
            public double[] optToModel(double[] dArray) {
                double[] dArray2;
                double d = dArray[1];
                dArray2 = new double[]{dArray[0], d, 1.0 - d, dArray[2], dArray[3], dArray[4], dArray2[3]};
                return dArray2;
            }

            @Override
            public int getNumOptParams() {
                return 5;
            }

            @Override
            public int getNumModelParams() {
                return 7;
            }

            @Override
            public int getDirectionIndex() {
                return 4;
            }
        };
    }

    @Override
    protected void makePrior() {
        this.prior = new Prior(){

            @Override
            public double prior(double[] dArray) {
                double d = dArray[0] < 0.0 ? 0.0 : 1.0;
                double d2 = dArray[1] < 0.0 || dArray[1] > 1.0 ? 0.0 : 1.0;
                double d3 = dArray[2] < 0.0 ? 0.0 : 1.0;
                double d4 = Math.abs(Math.sin(dArray[3]));
                return d * d2 * d3 * d4;
            }
        };
    }

    @Override
    protected void makePerturbation() {
        this.perturbation = new Perturbation(){

            @Override
            public double[] perturb(double[] dArray, double[] dArray2, Random random) {
                double[] dArray3 = new double[dArray.length];
                double d = 0.05;
                double d2 = 0.001;
                dArray3[0] = dArray[0] + dArray2[0] * d * random.nextGaussian();
                dArray3[1] = dArray[1] + d * random.nextGaussian();
                dArray3[2] = dArray[2] + dArray2[2] * d * random.nextGaussian();
                dArray3[3] = dArray[3] + d2 * random.nextGaussian();
                dArray3[4] = dArray[4] + d2 * random.nextGaussian();
                return dArray3;
            }
        };
    }

    @Override
    protected double[] getStartPoint(double[] dArray) {
        if (this.getFixedStartPoint(dArray) != null) {
            return this.getFixedStartPoint(dArray);
        }
        double[] dArray2 = this.dtfitter.invert(dArray);
        DT dT = new DT(dArray2[2], dArray2[3], dArray2[4], dArray2[5], dArray2[6], dArray2[7]);
        double d = dArray2[1];
        double[][] dArray3 = dT.sortedEigenSystem();
        Vector3D vector3D = new Vector3D(dArray3[1][0], dArray3[2][0], dArray3[3][0]);
        double[] dArray4 = Vector3D.thetaPhi(vector3D);
        double d2 = dArray4[0];
        double d3 = -dArray4[1];
        double d4 = dT.fa();
        double d5 = dT.trace() / 3.0;
        double[] dArray5 = new double[7];
        dArray5[0] = Math.exp(d);
        dArray5[1] = d4;
        dArray5[1] = dArray5[1] < 0.1 ? 0.1 : dArray5[1];
        dArray5[1] = dArray5[1] > 0.9 ? 0.9 : dArray5[1];
        dArray5[2] = 1.0 - dArray5[1];
        dArray5[3] = d5;
        dArray5[4] = d2;
        dArray5[5] = d3;
        dArray5[6] = dArray5[3];
        return dArray5;
    }

    public static void main(String[] stringArray) {
        CL_Initializer.CL_init(stringArray);
        CL_Initializer.checkParsing(stringArray);
        CL_Initializer.initImagingScheme();
        CL_Initializer.initDataSynthesizer();
        OutputManager outputManager = new OutputManager();
        BallStickMCMC_Fitter ballStickMCMC_Fitter = new BallStickMCMC_Fitter(CL_Initializer.imPars);
        int n = 1;
        while (CL_Initializer.data.more()) {
            try {
                long l = System.currentTimeMillis();
                double[] dArray = CL_Initializer.data.nextVoxel();
                double[][] dArray2 = ballStickMCMC_Fitter.fit(dArray);
                for (int i = 0; i < dArray2.length; ++i) {
                    outputManager.output(dArray2[i]);
                }
                long l2 = System.currentTimeMillis();
                logger.info(" current step is " + n + ", time of minimization is " + (l2 - l) + " ms.");
                ++n;
            }
            catch (Exception exception) {
                System.err.println(exception);
            }
        }
        outputManager.close();
    }
}

