/*
 * Decompiled with CFR 0.152.
 */
package fitters;

import data.OutputManager;
import fitters.BallStickLM_GaussianFitter;
import fitters.FixedSTD_GaussianPerturbation;
import imaging.DW_Scheme;
import inverters.LinearDT_Inversion;
import misc.LoggedException;
import models.compartments.CompartmentModel;
import optimizers.MultiRunLM_GaussianMinimizer;
import tools.CL_Initializer;

public class BallStickMultiRunLM_GaussianFitter
extends BallStickLM_GaussianFitter {
    public BallStickMultiRunLM_GaussianFitter(DW_Scheme dW_Scheme, int n, int n2) {
        this.scheme = dW_Scheme;
        this.makeCodec();
        String[] stringArray = new String[]{new String("stick"), new String("ball")};
        double[] dArray = new double[]{1.0, 0.3, 0.7, 1.7E-9, 1.570796326794897, 0.0, 1.7E-9};
        this.cm = new CompartmentModel(stringArray, dArray);
        try {
            this.minimizer = new MultiRunLM_GaussianMinimizer(dW_Scheme, this.cm, this.cod, new FixedSTD_GaussianPerturbation(), n, n2);
        }
        catch (Exception exception) {
            throw new LoggedException(exception);
        }
        this.dtfitter = new LinearDT_Inversion(dW_Scheme);
    }

    public static void main(String[] stringArray) {
        CL_Initializer.CL_init(stringArray);
        CL_Initializer.checkParsing(stringArray);
        CL_Initializer.initImagingScheme();
        CL_Initializer.initDataSynthesizer();
        OutputManager outputManager = new OutputManager();
        BallStickMultiRunLM_GaussianFitter ballStickMultiRunLM_GaussianFitter = new BallStickMultiRunLM_GaussianFitter(CL_Initializer.imPars, 3, 0);
        while (CL_Initializer.data.more()) {
            try {
                double[] dArray = CL_Initializer.data.nextVoxel();
                double[][] dArray2 = ballStickMultiRunLM_GaussianFitter.fit(dArray);
                for (int i = 0; i < dArray2.length; ++i) {
                    outputManager.output(dArray2[i]);
                }
            }
            catch (Exception exception) {
                System.err.println(exception);
            }
        }
        outputManager.close();
    }
}

