/*
 * Decompiled with CFR 0.152.
 */
package fitters;

import fitters.Fitter;
import fitters.NoiseModel;
import fitters.Perturbation;
import misc.LoggedException;
import models.compartments.CompartmentModel;
import optimizers.LM_GaussianMinimizer;
import optimizers.LM_OffGaussMinimizer;
import optimizers.LM_RicianMinimizer;
import optimizers.MarquardtMinimiserException;
import optimizers.MinimizerException;
import optimizers.MultiRunLM_GaussianMinimizer;
import optimizers.MultiRunLM_OffGaussMinimizer;
import optimizers.MultiRunLM_RicianMinimizer;
import tools.CL_Initializer;

public abstract class CompartmentFitter
extends Fitter {
    protected CompartmentModel cm;

    protected double[] getFixedStartPoint(double[] dArray) {
        if (CL_Initializer.fixedStartPoint) {
            String[] stringArray = this.cm.getCompartmentnames();
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equalsIgnoreCase(CL_Initializer.compartmentNames[i])) continue;
                throw new LoggedException("Fixed startpoint doesn't match fitmodel.Given: " + CL_Initializer.compartmentNames[i] + ". Expected: " + stringArray[i]);
            }
            return CL_Initializer.compParams;
        }
        return null;
    }

    protected void initLM_Minimizer(NoiseModel noiseModel) throws MarquardtMinimiserException {
        if (noiseModel == NoiseModel.GAUSSIAN) {
            this.minimizer = new LM_GaussianMinimizer(this.scheme, this.cm, this.cod);
        } else if (noiseModel == NoiseModel.OFFGAUSS) {
            if (CL_Initializer.sigma < 0.0) {
                throw new LoggedException("No valid noise level specified: use -sigma.");
            }
            this.minimizer = new LM_OffGaussMinimizer(this.scheme, this.cm, this.cod, CL_Initializer.sigma);
        } else if (noiseModel == NoiseModel.RICIAN) {
            if (CL_Initializer.sigma < 0.0) {
                throw new LoggedException("No valid noise level specified: use -sigma.");
            }
            this.minimizer = new LM_RicianMinimizer(this.scheme, this.cm, this.cod, CL_Initializer.sigma);
        } else {
            throw new LoggedException("Unknown noise model: " + (Object)((Object)noiseModel));
        }
    }

    protected void initMultiRunLM_Minimizer(NoiseModel noiseModel, Perturbation perturbation, int n, int n2) throws MinimizerException {
        if (noiseModel == NoiseModel.GAUSSIAN) {
            this.minimizer = new MultiRunLM_GaussianMinimizer(this.scheme, this.cm, this.cod, perturbation, n, n2);
        } else if (noiseModel == NoiseModel.OFFGAUSS) {
            if (CL_Initializer.sigma < 0.0) {
                throw new LoggedException("No valid noise level specified: use -sigma.");
            }
            this.minimizer = new MultiRunLM_OffGaussMinimizer(this.scheme, this.cm, this.cod, perturbation, n, n2, CL_Initializer.sigma);
        } else if (noiseModel == NoiseModel.RICIAN) {
            if (CL_Initializer.sigma < 0.0) {
                throw new LoggedException("No valid noise level specified: use -sigma.");
            }
            this.minimizer = new MultiRunLM_RicianMinimizer(this.scheme, this.cm, this.cod, perturbation, n, n2, CL_Initializer.sigma);
        } else {
            throw new LoggedException("Unknown noise model: " + (Object)((Object)noiseModel));
        }
    }
}

