/*
 * Decompiled with CFR 0.152.
 */
package fitters;

import fitters.Codec;
import imaging.DW_Scheme;
import optimizers.Minimizer;
import optimizers.MinimizerException;

public abstract class Fitter {
    protected DW_Scheme scheme;
    protected Codec cod;
    protected Minimizer minimizer;

    public double[][] fit(double[] dArray) throws MinimizerException {
        this.minimizer.setMeasurements(dArray);
        double[] dArray2 = this.getStartPoint(dArray);
        this.minimizer.setInitParams(this.cod.modelToOpt(dArray2));
        this.minimizer.minimise();
        return this.minimizer.getSolutions();
    }

    public int getNumValuesPerRun() {
        return (this.cod.getNumModelParams() + 2) * this.minimizer.getNumSolutions();
    }

    public int getNumValuesPerSolution() {
        return this.cod.getNumModelParams() + 2;
    }

    public int getDirectionIndex() {
        return this.cod.getDirectionIndex() + 1;
    }

    protected abstract double[] getStartPoint(double[] var1);
}

