/*
 * Decompiled with CFR 0.152.
 */
package fitters;

import fitters.CompartmentFitter;
import fitters.NoiseModel;
import fitters.Perturbation;
import fitters.Prior;
import imaging.DW_Scheme;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import misc.LoggedException;
import models.compartments.CompartmentModel;
import optimizers.MCMC_GaussianMinimizer;
import optimizers.MCMC_Minimizer;
import optimizers.MCMC_OffGaussMinimizer;
import optimizers.MCMC_RicianMinimizer;
import optimizers.MarkovChainMonteCarloException;
import optimizers.MinimizerException;
import tools.CL_Initializer;

public abstract class MCMC_Fitter
extends CompartmentFitter {
    protected Prior prior;
    protected Perturbation perturbation;
    protected DataOutputStream statsFile;

    public MCMC_Fitter() {
    }

    public MCMC_Fitter(DW_Scheme dW_Scheme, String[] stringArray, double[] dArray) {
        if (CL_Initializer.mcmcStatsFile != null) {
            try {
                this.statsFile = new DataOutputStream(new FileOutputStream(CL_Initializer.mcmcStatsFile));
            }
            catch (Exception exception) {
                throw new LoggedException(exception);
            }
        }
        this.scheme = dW_Scheme;
        this.makeCodec();
        this.makePrior();
        this.makePerturbation();
        this.cm = new CompartmentModel(stringArray, dArray);
        try {
            this.initMCMC_Minimizer(NoiseModel.getNoiseModel(CL_Initializer.noiseModel));
        }
        catch (Exception exception) {
            throw new LoggedException(exception);
        }
    }

    protected void initMCMC_Minimizer(NoiseModel noiseModel) throws MarkovChainMonteCarloException {
        if (CL_Initializer.sigma < 0.0) {
            throw new LoggedException("No valid noise level specified; required for MCMC: use -sigma.");
        }
        if (noiseModel == NoiseModel.GAUSSIAN) {
            this.minimizer = new MCMC_GaussianMinimizer(this.scheme, this.cm, this.cod, this.prior, this.perturbation, CL_Initializer.sigma);
        } else if (noiseModel == NoiseModel.OFFGAUSS) {
            if (CL_Initializer.sigma < 0.0) {
                throw new LoggedException("No valid noise level specified: use -sigma.");
            }
            this.minimizer = new MCMC_OffGaussMinimizer(this.scheme, this.cm, this.cod, this.prior, this.perturbation, CL_Initializer.sigma);
        } else if (noiseModel == NoiseModel.RICIAN) {
            if (CL_Initializer.sigma < 0.0) {
                throw new LoggedException("No valid noise level specified: use -sigma.");
            }
            this.minimizer = new MCMC_RicianMinimizer(this.scheme, this.cm, this.cod, this.prior, this.perturbation, CL_Initializer.sigma);
        } else {
            throw new LoggedException("Unknown noise model: " + (Object)((Object)noiseModel));
        }
    }

    @Override
    public double[][] fit(double[] dArray) throws MinimizerException {
        double[][] dArray2 = super.fit(dArray);
        if (CL_Initializer.mcmcStatsFile != null) {
            try {
                this.statsFile.writeDouble(((MCMC_Minimizer)this.minimizer).getAcceptanceRate());
            }
            catch (Exception exception) {
                throw new LoggedException(exception);
            }
        }
        return dArray2;
    }

    protected abstract void makeCodec();

    protected abstract void makePrior();

    protected abstract void makePerturbation();
}

