/*
 * Decompiled with CFR 0.152.
 */
package fitters;

import data.OutputManager;
import fitters.Codec;
import fitters.CompartmentFitter;
import fitters.FitModel;
import fitters.NoiseModel;
import imaging.DW_Scheme;
import inverters.LinearDT_Inversion;
import misc.DT;
import misc.LoggedException;
import models.compartments.CompartmentModel;
import numerics.RealMatrix;
import numerics.Vector3D;
import optimizers.LM_Minimizer;
import tools.CL_Initializer;

public class MMWMD_BasicLM_DirectFitter
extends CompartmentFitter {
    protected LinearDT_Inversion dtfitter;
    private final int numModelParams = 11;
    private final int numOptParams = 5;
    protected double WMDIFF = 1.7E-9;

    public MMWMD_BasicLM_DirectFitter() {
    }

    public MMWMD_BasicLM_DirectFitter(DW_Scheme dW_Scheme) {
        this(dW_Scheme, FitModel.getCompartmentList(CL_Initializer.fitModel), FitModel.getCompartmentModelParams(CL_Initializer.fitModel));
    }

    public MMWMD_BasicLM_DirectFitter(DW_Scheme dW_Scheme, String[] stringArray, double[] dArray) {
        if (CL_Initializer.mmwmddiff > 0.0) {
            this.WMDIFF = CL_Initializer.mmwmddiff;
        }
        this.scheme = dW_Scheme;
        this.makeCodec();
        this.cm = new CompartmentModel(stringArray, dArray);
        try {
            this.initLM_Minimizer(NoiseModel.getNoiseModel(CL_Initializer.noiseModel));
            LM_Minimizer cfr_ignored_0 = (LM_Minimizer)this.minimizer;
            LM_Minimizer.setCONVERGETHRESH(1.0E-8);
            LM_Minimizer cfr_ignored_1 = (LM_Minimizer)this.minimizer;
            LM_Minimizer.setMAXITER(5000);
        }
        catch (Exception exception) {
            throw new LoggedException(exception);
        }
        this.dtfitter = new LinearDT_Inversion(dW_Scheme);
    }

    protected void makeCodec() {
        this.cod = new Codec(){
            private double minR = 1.0E-7;
            private double maxR = 2.0E-5;

            @Override
            public double[] modelToOpt(double[] dArray) {
                double[] dArray2 = new double[]{Math.sqrt(dArray[0]), Math.acos(Math.sqrt(dArray[1])), dArray[4], dArray[5], Math.acos(Math.sqrt((dArray[6] - this.minR) / (this.maxR - this.minR)))};
                return dArray2;
            }

            @Override
            public double[] optToModel(double[] dArray) {
                double[] dArray2 = new double[11];
                dArray2[0] = dArray[0] * dArray[0];
                double d = Math.cos(dArray[1]);
                dArray2[1] = d * d;
                dArray2[2] = 1.0 - dArray2[1];
                dArray2[3] = MMWMD_BasicLM_DirectFitter.this.WMDIFF;
                dArray2[4] = dArray[2];
                dArray2[5] = dArray[3];
                dArray2[6] = this.minR + Math.cos(dArray[4]) * Math.cos(dArray[4]) * (this.maxR - this.minR);
                dArray2[7] = MMWMD_BasicLM_DirectFitter.this.WMDIFF;
                dArray2[8] = dArray[2];
                dArray2[9] = dArray[3];
                dArray2[10] = MMWMD_BasicLM_DirectFitter.this.WMDIFF * dArray2[2];
                return dArray2;
            }

            @Override
            public RealMatrix getJacobian(double[] dArray) {
                RealMatrix realMatrix = new RealMatrix(11, 5);
                realMatrix.entries[0][0] = 2.0 * dArray[0];
                double d = Math.sin(dArray[1]) * Math.cos(dArray[1]);
                realMatrix.entries[1][1] = -2.0 * d;
                realMatrix.entries[2][1] = 2.0 * d;
                realMatrix.entries[4][2] = 1.0;
                realMatrix.entries[5][3] = 1.0;
                realMatrix.entries[6][4] = -2.0 * (this.maxR - this.minR) * Math.sin(dArray[4]) * Math.cos(dArray[4]);
                realMatrix.entries[8][2] = 1.0;
                realMatrix.entries[9][3] = 1.0;
                realMatrix.entries[10][1] = -MMWMD_BasicLM_DirectFitter.this.WMDIFF * realMatrix.entries[1][1];
                return realMatrix;
            }

            @Override
            public int getNumOptParams() {
                return 5;
            }

            @Override
            public int getNumModelParams() {
                return 11;
            }

            @Override
            public int getDirectionIndex() {
                return 4;
            }
        };
    }

    @Override
    protected double[] getStartPoint(double[] dArray) {
        if (this.getFixedStartPoint(dArray) != null) {
            return this.getFixedStartPoint(dArray);
        }
        double[] dArray2 = this.dtfitter.invert(dArray);
        DT dT = new DT(dArray2[2], dArray2[3], dArray2[4], dArray2[5], dArray2[6], dArray2[7]);
        double d = dArray2[1];
        double[][] dArray3 = dT.sortedEigenSystem();
        Vector3D vector3D = new Vector3D(dArray3[1][0], dArray3[2][0], dArray3[3][0]);
        double[] dArray4 = Vector3D.thetaPhi(vector3D);
        double d2 = dArray4[0];
        double d3 = -dArray4[1];
        double d4 = dT.fa();
        double[] dArray5 = new double[11];
        dArray5[0] = Math.exp(d);
        dArray5[1] = d4;
        dArray5[1] = dArray5[1] < 0.1 ? 0.1 : dArray5[1];
        dArray5[1] = dArray5[1] > 0.9 ? 0.9 : dArray5[1];
        dArray5[2] = 1.0 - dArray5[1];
        dArray5[3] = this.WMDIFF;
        dArray5[4] = d2;
        dArray5[5] = d3;
        dArray5[6] = 1.0E-6;
        dArray5[7] = this.WMDIFF;
        dArray5[8] = d2;
        dArray5[9] = d3;
        dArray5[10] = dArray5[2] * this.WMDIFF;
        return dArray5;
    }

    public static void main(String[] stringArray) {
        CL_Initializer.CL_init(stringArray);
        CL_Initializer.checkParsing(stringArray);
        CL_Initializer.initImagingScheme();
        CL_Initializer.initDataSynthesizer();
        OutputManager outputManager = new OutputManager();
        MMWMD_BasicLM_DirectFitter mMWMD_BasicLM_DirectFitter = new MMWMD_BasicLM_DirectFitter(CL_Initializer.imPars);
        while (CL_Initializer.data.more()) {
            try {
                double[] dArray = CL_Initializer.data.nextVoxel();
                double[][] dArray2 = mMWMD_BasicLM_DirectFitter.fit(dArray);
                outputManager.output(dArray2[0]);
            }
            catch (Exception exception) {
                System.err.println(exception);
            }
        }
        outputManager.close();
    }
}

