/*
 * Decompiled with CFR 0.152.
 */
package fitters;

import data.OutputManager;
import fitters.Codec;
import fitters.FitModel;
import fitters.MCMC_Fitter;
import fitters.MMWMD_InVivoMultiRunLM_DirectFitter;
import fitters.Perturbation;
import fitters.Prior;
import imaging.DW_Scheme;
import java.util.Random;
import java.util.logging.Logger;
import optimizers.MinimizerException;
import optimizers.MultiRunMinimizer;
import tools.CL_Initializer;

public class MMWMD_InVivoMCMC_Fitter
extends MCMC_Fitter {
    private static Logger logger = Logger.getLogger("camino.fitters.MMWMD_InVivoMCMC_Fitter");
    protected MMWMD_InVivoMultiRunLM_DirectFitter gdfitter;
    protected int GDRUNS = 1;
    private final int numModelParams = 13;
    private final int numOptParams = 6;
    protected double WMDIFF = 1.7E-9;
    protected double CSFDIFF = 3.0E-9;

    public MMWMD_InVivoMCMC_Fitter() {
    }

    public MMWMD_InVivoMCMC_Fitter(DW_Scheme dW_Scheme) {
        this(dW_Scheme, FitModel.getCompartmentList(CL_Initializer.fitModel), FitModel.getCompartmentModelParams(CL_Initializer.fitModel));
    }

    public MMWMD_InVivoMCMC_Fitter(DW_Scheme dW_Scheme, String[] stringArray, double[] dArray) {
        super(dW_Scheme, stringArray, dArray);
        if (CL_Initializer.mmwmddiff > 0.0) {
            this.WMDIFF = CL_Initializer.mmwmddiff;
        }
        this.gdfitter = new MMWMD_InVivoMultiRunLM_DirectFitter(dW_Scheme, this.GDRUNS, CL_Initializer.seed);
    }

    @Override
    protected void makeCodec() {
        this.cod = new Codec(){

            @Override
            public double[] modelToOpt(double[] dArray) {
                double[] dArray2 = new double[]{dArray[0], dArray[1], dArray[2], dArray[5], dArray[6], dArray[7]};
                return dArray2;
            }

            @Override
            public double[] optToModel(double[] dArray) {
                double[] dArray2;
                dArray2 = new double[]{dArray[0], dArray[1], dArray[2], 1.0 - dArray2[1] - dArray2[2], MMWMD_InVivoMCMC_Fitter.this.WMDIFF, dArray[3], dArray[4], dArray[5], MMWMD_InVivoMCMC_Fitter.this.WMDIFF, dArray[3], dArray[4], MMWMD_InVivoMCMC_Fitter.this.WMDIFF * dArray2[2] / (dArray2[1] + dArray2[2]), MMWMD_InVivoMCMC_Fitter.this.CSFDIFF};
                return dArray2;
            }

            @Override
            public int getNumOptParams() {
                return 6;
            }

            @Override
            public int getNumModelParams() {
                return 13;
            }

            @Override
            public int getDirectionIndex() {
                return 5;
            }
        };
    }

    @Override
    protected void makePrior() {
        this.prior = new Prior(){
            private double minR = 1.0E-7;
            private double maxR = 2.0E-5;

            @Override
            public double prior(double[] dArray) {
                double d = dArray[0] < 0.0 ? 0.0 : 1.0;
                double d2 = dArray[1] < 0.0 || dArray[1] > 1.0 ? 0.0 : 1.0;
                double d3 = dArray[2] < 0.0 || dArray[2] > 1.0 - dArray[1] ? 0.0 : 1.0;
                double d4 = Math.abs(Math.sin(dArray[3]));
                double d5 = dArray[5] < this.minR || dArray[5] > this.maxR ? 0.0 : 1.0;
                return d * d2 * d3 * d4 * d5;
            }
        };
    }

    @Override
    protected void makePerturbation() {
        this.perturbation = new Perturbation(){

            @Override
            public double[] perturb(double[] dArray, double[] dArray2, Random random) {
                double[] dArray3 = new double[dArray.length];
                double d = 0.05;
                double d2 = 0.001;
                dArray3[0] = dArray[0];
                dArray3[1] = dArray[1] + d * random.nextGaussian();
                dArray3[2] = dArray[1] + dArray[2] - dArray3[1];
                dArray3[3] = dArray[3];
                dArray3[4] = dArray[4];
                dArray3[5] = dArray[5] + dArray2[5] * d * random.nextGaussian();
                return dArray3;
            }
        };
    }

    @Override
    protected double[] getStartPoint(double[] dArray) {
        if (this.getFixedStartPoint(dArray) != null) {
            return this.getFixedStartPoint(dArray);
        }
        double[] dArray2 = new double[13];
        try {
            double[] dArray3 = MultiRunMinimizer.getBestSolution(this.gdfitter.fit(dArray));
            for (int i = 0; i < dArray2.length; ++i) {
                dArray2[i] = dArray3[i + 1];
            }
        }
        catch (MinimizerException minimizerException) {
            dArray2 = this.gdfitter.getStartPoint(dArray);
            logger.warning(minimizerException.toString());
        }
        return dArray2;
    }

    public static void main(String[] stringArray) {
        CL_Initializer.CL_init(stringArray);
        CL_Initializer.checkParsing(stringArray);
        CL_Initializer.initImagingScheme();
        CL_Initializer.initDataSynthesizer();
        OutputManager outputManager = new OutputManager();
        MMWMD_InVivoMCMC_Fitter mMWMD_InVivoMCMC_Fitter = new MMWMD_InVivoMCMC_Fitter(CL_Initializer.imPars);
        int n = 1;
        while (CL_Initializer.data.more()) {
            try {
                long l = System.currentTimeMillis();
                double[] dArray = CL_Initializer.data.nextVoxel();
                double[][] dArray2 = mMWMD_InVivoMCMC_Fitter.fit(dArray);
                for (int i = 0; i < dArray2.length; ++i) {
                    outputManager.output(dArray2[i]);
                }
                long l2 = System.currentTimeMillis();
                logger.info(" current step is " + n + ", time of minimization is " + (l2 - l) + " ms.");
                ++n;
            }
            catch (Exception exception) {
                System.err.println(exception);
            }
        }
        outputManager.close();
    }
}

