/*
 * Decompiled with CFR 0.152.
 */
package fitters;

import data.OutputManager;
import fitters.BallCylinderLM_Fitter;
import fitters.BallCylinderMultiRunLM_Fitter;
import fitters.Codec;
import fitters.CompartmentFitter;
import fitters.NoiseModel;
import fitters.TensorStickLM_Fitter;
import fitters.TensorStickMultiRunLM_Fitter;
import imaging.DW_Scheme;
import misc.LoggedException;
import models.compartments.CompartmentModel;
import optimizers.LM_Minimizer;
import optimizers.MinimizerException;
import optimizers.MultiRunMinimizer;
import tools.CL_Initializer;

public class TensorCylinderLM_Fitter
extends CompartmentFitter {
    protected BallCylinderLM_Fitter bcfitter;
    protected TensorStickLM_Fitter tsfitter;
    private final int numModelParams = 13;
    private final int numOptParams = 9;

    public TensorCylinderLM_Fitter() {
    }

    public TensorCylinderLM_Fitter(DW_Scheme dW_Scheme) {
        this.scheme = dW_Scheme;
        this.makeCodec();
        String[] stringArray = new String[]{new String("cylindergpd"), new String("tensor")};
        double[] dArray = new double[]{1.0, 0.7, 0.3, 1.7E-9, 1.570796326794897, 1.570796326794897, 2.0E-6, 1.7E-9, 1.570796326794897, 1.570796326794897, 1.7E-10, 1.7E-11, 1.5};
        this.cm = new CompartmentModel(stringArray, dArray);
        try {
            this.initLM_Minimizer(NoiseModel.getNoiseModel(CL_Initializer.noiseModel));
            LM_Minimizer cfr_ignored_0 = (LM_Minimizer)this.minimizer;
            LM_Minimizer.setCONVERGETHRESH(1.0E-8);
            LM_Minimizer cfr_ignored_1 = (LM_Minimizer)this.minimizer;
            LM_Minimizer.setMAXITER(5000);
        }
        catch (Exception exception) {
            throw new LoggedException(exception);
        }
        this.bcfitter = new BallCylinderMultiRunLM_Fitter(dW_Scheme, 1, 0);
        this.tsfitter = new TensorStickMultiRunLM_Fitter(dW_Scheme, 1, 0);
    }

    protected void makeCodec() {
        this.cod = new Codec(){

            @Override
            public double[] modelToOpt(double[] dArray) {
                double[] dArray2 = new double[]{Math.sqrt(dArray[0]), Math.acos(Math.sqrt(dArray[1])), Math.sqrt(dArray[3]), dArray[4], dArray[5], Math.acos(Math.sqrt((dArray[6] - 1.0E-7) / 2.0E-5)), Math.asin(Math.sqrt(dArray[10] / dArray[3])), Math.asin(Math.sqrt(dArray[11] / dArray[10])), dArray[12]};
                return dArray2;
            }

            @Override
            public double[] optToModel(double[] dArray) {
                double[] dArray2 = new double[13];
                dArray2[0] = dArray[0] * dArray[0];
                double d = Math.cos(dArray[1]);
                d *= d;
                dArray2[1] = d;
                dArray2[2] = 1.0 - d;
                dArray2[3] = dArray[2] * dArray[2];
                dArray2[4] = dArray[3];
                dArray2[5] = dArray[4];
                dArray2[6] = 1.0E-7 + Math.cos(dArray[5]) * Math.cos(dArray[5]) * 2.0E-5;
                dArray2[7] = dArray2[3];
                dArray2[8] = dArray2[4];
                dArray2[9] = dArray2[5];
                dArray2[10] = Math.sin(dArray[6]) * Math.sin(dArray[6]);
                dArray2[10] = dArray2[10] * dArray2[3];
                dArray2[11] = Math.sin(dArray[7]) * Math.sin(dArray[7]);
                dArray2[11] = dArray2[11] * dArray2[10];
                dArray2[12] = dArray[8];
                return dArray2;
            }

            @Override
            public int getNumOptParams() {
                return 9;
            }

            @Override
            public int getNumModelParams() {
                return 13;
            }

            @Override
            public int getDirectionIndex() {
                return 4;
            }
        };
    }

    @Override
    protected double[] getStartPoint(double[] dArray) {
        double[] dArray2;
        double[] dArray3;
        if (this.getFixedStartPoint(dArray) != null) {
            return this.getFixedStartPoint(dArray);
        }
        try {
            dArray3 = MultiRunMinimizer.getBestSolution(this.tsfitter.fit(dArray));
        }
        catch (MinimizerException minimizerException) {
            dArray3 = this.tsfitter.getStartPoint(dArray);
            minimizerException.printStackTrace();
        }
        double d = dArray3[1];
        double d2 = dArray3[2];
        double d3 = dArray3[4];
        double d4 = dArray3[5];
        double d5 = dArray3[6];
        double d6 = dArray3[10];
        double d7 = dArray3[11];
        double d8 = dArray3[12];
        try {
            dArray2 = MultiRunMinimizer.getBestSolution(this.bcfitter.fit(dArray));
        }
        catch (MinimizerException minimizerException) {
            dArray2 = this.bcfitter.getStartPoint(dArray);
            minimizerException.printStackTrace();
        }
        double d9 = dArray2[7];
        double[] dArray4 = new double[13];
        dArray4[0] = d;
        dArray4[1] = d2;
        dArray4[1] = dArray4[1] < 0.1 ? 0.1 : dArray4[1];
        dArray4[1] = dArray4[1] > 0.9 ? 0.9 : dArray4[1];
        dArray4[2] = 1.0 - dArray4[1];
        dArray4[3] = d3;
        dArray4[4] = d4;
        dArray4[5] = d5;
        dArray4[6] = d9;
        dArray4[7] = dArray4[3];
        dArray4[8] = dArray4[4];
        dArray4[9] = dArray4[5];
        dArray4[10] = d6;
        dArray4[11] = d7;
        dArray4[12] = d8;
        return dArray4;
    }

    public static void main(String[] stringArray) {
        CL_Initializer.CL_init(stringArray);
        CL_Initializer.checkParsing(stringArray);
        CL_Initializer.initImagingScheme();
        CL_Initializer.initDataSynthesizer();
        OutputManager outputManager = new OutputManager();
        TensorCylinderLM_Fitter tensorCylinderLM_Fitter = new TensorCylinderLM_Fitter(CL_Initializer.imPars);
        while (CL_Initializer.data.more()) {
            try {
                double[] dArray = CL_Initializer.data.nextVoxel();
                double[][] dArray2 = tensorCylinderLM_Fitter.fit(dArray);
                outputManager.output(dArray2[0]);
            }
            catch (Exception exception) {
                System.err.println(exception);
            }
        }
        outputManager.close();
    }
}

