/*
 * Decompiled with CFR 0.152.
 */
package fitters;

import data.OutputManager;
import fitters.Codec;
import fitters.CompartmentFitter;
import fitters.NoiseModel;
import fitters.ZeppelinStickLM_Fitter;
import fitters.ZeppelinStickMultiRunLM_Fitter;
import imaging.DW_Scheme;
import inverters.LinearDT_Inversion;
import misc.DT;
import misc.LoggedException;
import models.compartments.CompartmentModel;
import optimizers.LM_Minimizer;
import optimizers.MinimizerException;
import optimizers.MultiRunMinimizer;
import tools.CL_Initializer;

public class TensorStickLM_Fitter
extends CompartmentFitter {
    protected LinearDT_Inversion dtfitter;
    protected ZeppelinStickLM_Fitter zsfitter;
    private final int numModelParams = 12;
    private final int numOptParams = 8;

    public TensorStickLM_Fitter() {
    }

    public TensorStickLM_Fitter(DW_Scheme dW_Scheme) {
        this.scheme = dW_Scheme;
        this.makeCodec();
        String[] stringArray = new String[]{new String("stick"), new String("tensor")};
        double[] dArray = new double[]{1.0, 0.7, 0.3, 1.7E-9, 1.570796326794897, 1.570796326794897, 1.7E-9, 1.570796326794897, 1.570796326794897, 1.7E-10, 1.7E-11, 1.5};
        this.cm = new CompartmentModel(stringArray, dArray);
        try {
            this.initLM_Minimizer(NoiseModel.getNoiseModel(CL_Initializer.noiseModel));
            LM_Minimizer cfr_ignored_0 = (LM_Minimizer)this.minimizer;
            LM_Minimizer.setCONVERGETHRESH(1.0E-8);
            LM_Minimizer cfr_ignored_1 = (LM_Minimizer)this.minimizer;
            LM_Minimizer.setMAXITER(5000);
        }
        catch (Exception exception) {
            throw new LoggedException(exception);
        }
        this.dtfitter = new LinearDT_Inversion(dW_Scheme);
        this.zsfitter = new ZeppelinStickMultiRunLM_Fitter(dW_Scheme, 1, 0);
    }

    protected void makeCodec() {
        this.cod = new Codec(){

            @Override
            public double[] modelToOpt(double[] dArray) {
                double[] dArray2 = new double[]{Math.sqrt(dArray[0]), Math.acos(Math.sqrt(dArray[1])), Math.sqrt(dArray[3]), dArray[4], dArray[5], Math.asin(Math.sqrt(dArray[9] / dArray[3])), Math.asin(Math.sqrt(dArray[10] / dArray[9])), dArray[11]};
                return dArray2;
            }

            @Override
            public double[] optToModel(double[] dArray) {
                double[] dArray2 = new double[12];
                dArray2[0] = dArray[0] * dArray[0];
                double d = Math.cos(dArray[1]);
                d *= d;
                dArray2[1] = d;
                dArray2[2] = 1.0 - d;
                dArray2[3] = dArray[2] * dArray[2];
                dArray2[4] = dArray[3];
                dArray2[5] = dArray[4];
                dArray2[6] = dArray2[3];
                dArray2[7] = dArray2[4];
                dArray2[8] = dArray2[5];
                dArray2[9] = Math.sin(dArray[5]) * Math.sin(dArray[5]);
                dArray2[9] = dArray2[9] * dArray2[3];
                dArray2[10] = Math.sin(dArray[6]) * Math.sin(dArray[6]);
                dArray2[10] = dArray2[10] * dArray2[9];
                dArray2[11] = dArray[7];
                return dArray2;
            }

            @Override
            public int getNumOptParams() {
                return 8;
            }

            @Override
            public int getNumModelParams() {
                return 12;
            }

            @Override
            public int getDirectionIndex() {
                return 4;
            }
        };
    }

    @Override
    protected double[] getStartPoint(double[] dArray) {
        double[] dArray2;
        if (this.getFixedStartPoint(dArray) != null) {
            return this.getFixedStartPoint(dArray);
        }
        try {
            dArray2 = MultiRunMinimizer.getBestSolution(this.zsfitter.fit(dArray));
        }
        catch (MinimizerException minimizerException) {
            dArray2 = this.zsfitter.getStartPoint(dArray);
            minimizerException.printStackTrace();
        }
        double d = dArray2[1];
        double d2 = dArray2[5];
        double d3 = dArray2[6];
        double d4 = dArray2[2];
        double d5 = dArray2[4];
        double[] dArray3 = this.dtfitter.invert(dArray);
        DT dT = new DT(dArray3[2], dArray3[3], dArray3[4], dArray3[5], dArray3[6], dArray3[7]);
        double[][] dArray4 = dT.sortedEigenSystem();
        double d6 = dArray2[10];
        double d7 = dArray4[0][2];
        double[] dArray5 = new double[12];
        dArray5[0] = d;
        dArray5[1] = d4;
        dArray5[1] = dArray5[1] < 0.1 ? 0.1 : dArray5[1];
        dArray5[1] = dArray5[1] > 0.9 ? 0.9 : dArray5[1];
        dArray5[2] = 1.0 - dArray5[1];
        dArray5[3] = d5;
        dArray5[4] = d2;
        dArray5[5] = d3;
        dArray5[6] = dArray5[3];
        dArray5[7] = dArray5[4];
        dArray5[8] = dArray5[5];
        dArray5[9] = d6;
        dArray5[9] = dArray5[9] < 1.0E-11 ? 1.0E-11 : dArray5[9];
        dArray5[10] = d7;
        dArray5[10] = dArray5[10] < 1.0E-11 ? 1.0E-11 : dArray5[10];
        dArray5[11] = 0.0;
        return dArray5;
    }

    public static void main(String[] stringArray) {
        CL_Initializer.CL_init(stringArray);
        CL_Initializer.checkParsing(stringArray);
        CL_Initializer.initImagingScheme();
        CL_Initializer.initDataSynthesizer();
        OutputManager outputManager = new OutputManager();
        TensorStickLM_Fitter tensorStickLM_Fitter = new TensorStickLM_Fitter(CL_Initializer.imPars);
        while (CL_Initializer.data.more()) {
            try {
                double[] dArray = CL_Initializer.data.nextVoxel();
                double[][] dArray2 = tensorStickLM_Fitter.fit(dArray);
                outputManager.output(dArray2[0]);
            }
            catch (Exception exception) {
                System.err.println(exception);
            }
        }
        outputManager.close();
    }
}

