/*
 * Decompiled with CFR 0.152.
 */
package fitters;

import data.OutputManager;
import fitters.FixedSTD_GaussianPerturbation;
import fitters.NoiseModel;
import fitters.ZeppelinCylinderTortLM_Fitter;
import imaging.DW_Scheme;
import inverters.LinearDT_Inversion;
import misc.LoggedException;
import models.compartments.CompartmentModel;
import optimizers.MultiRunLM_Minimizer;
import tools.CL_Initializer;

public class ZeppelinCylinderTortMultiRunLM_Fitter
extends ZeppelinCylinderTortLM_Fitter {
    public ZeppelinCylinderTortMultiRunLM_Fitter(DW_Scheme dW_Scheme, int n, int n2) {
        this.scheme = dW_Scheme;
        this.makeCodec();
        String[] stringArray = new String[]{new String("cylindergpd"), new String("zeppelin")};
        double[] dArray = new double[7];
        this.cm = new CompartmentModel(stringArray, dArray);
        try {
            this.initMultiRunLM_Minimizer(NoiseModel.getNoiseModel(CL_Initializer.noiseModel), new FixedSTD_GaussianPerturbation(), n, n2);
            ((MultiRunLM_Minimizer)this.minimizer).setCONVERGETHRESH(1.0E-8);
            ((MultiRunLM_Minimizer)this.minimizer).setMAXITER(5000);
        }
        catch (Exception exception) {
            throw new LoggedException(exception);
        }
        this.dtfitter = new LinearDT_Inversion(dW_Scheme);
    }

    public static void main(String[] stringArray) {
        CL_Initializer.CL_init(stringArray);
        CL_Initializer.checkParsing(stringArray);
        CL_Initializer.initImagingScheme();
        CL_Initializer.initDataSynthesizer();
        OutputManager outputManager = new OutputManager();
        ZeppelinCylinderTortMultiRunLM_Fitter zeppelinCylinderTortMultiRunLM_Fitter = new ZeppelinCylinderTortMultiRunLM_Fitter(CL_Initializer.imPars, 3, 0);
        while (CL_Initializer.data.more()) {
            try {
                double[] dArray = CL_Initializer.data.nextVoxel();
                double[][] dArray2 = zeppelinCylinderTortMultiRunLM_Fitter.fit(dArray);
                for (int i = 0; i < dArray2.length; ++i) {
                    outputManager.output(dArray2[i]);
                }
            }
            catch (Exception exception) {
                System.err.println(exception);
            }
        }
        outputManager.close();
    }
}

