/*
 * Decompiled with CFR 0.152.
 */
package imaging;

import imaging.DW_Scheme;
import imaging.SimulableScheme;
import java.util.Scanner;
import java.util.Vector;
import java.util.logging.Logger;
import misc.LoggedException;

public class GradientWaveform_Scheme
extends DW_Scheme
implements SimulableScheme {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    protected static final String VERSION = "GRADIENT_WAVEFORM";
    private final double[][][] gradWave;
    private final double[] dt;
    protected final boolean[] zero;
    private final int numZeros;

    private GradientWaveform_Scheme(double[][][] dArray, double[] dArray2) {
        super(new double[0][0]);
        this.dt = dArray2;
        this.gradWave = dArray;
        this.zero = new boolean[dArray.length];
        int n = 0;
        for (int i = 0; i < dArray.length; ++i) {
            this.zero[i] = true;
            for (int j = 0; j < dArray[i].length; ++j) {
                for (int k = 0; k < 3; ++k) {
                    if (dArray[i][j][k] == 0.0) continue;
                    this.zero[i] = false;
                    break;
                }
                if (!this.zero[i]) break;
            }
            if (!this.zero[i]) continue;
            ++n;
        }
        this.numZeros = n;
    }

    @Override
    public int numMeasurements() {
        return this.gradWave.length;
    }

    @Override
    public int numZeroMeasurements() {
        return this.numZeros;
    }

    private GradientWaveform_Scheme flippedScheme(int n) {
        double[][][] dArrayArray = new double[this.gradWave.length][][];
        for (int i = 0; i < dArrayArray.length; ++i) {
            dArrayArray[i] = new double[this.gradWave[i].length][3];
            for (int j = 0; j < dArrayArray[i].length; ++j) {
                for (int k = 0; k < 3; ++k) {
                    dArrayArray[i][j][k] = k == n ? -this.gradWave[i][j][k] : this.gradWave[i][j][k];
                }
            }
        }
        return new GradientWaveform_Scheme(dArrayArray, this.dt);
    }

    @Override
    public DW_Scheme flipX() {
        return this.flippedScheme(0);
    }

    @Override
    public DW_Scheme flipY() {
        return this.flippedScheme(1);
    }

    @Override
    public DW_Scheme flipZ() {
        return this.flippedScheme(2);
    }

    @Override
    public double getB_Value(int n) {
        double d = 0.0;
        for (int i = 0; i < this.gradWave[n].length; ++i) {
            double[] dArray = this.getGradientIntegral(n, i);
            double d2 = 0.0;
            for (int j = 0; j < 3; ++j) {
                d2 += dArray[j] * dArray[j];
            }
            d += d2;
        }
        d *= this.dt[n];
        return d *= 7.15644089825625E16;
    }

    private double[] getGradientIntegral(int n, int n2) {
        double[] dArray = new double[3];
        int n3 = 0;
        while (n3 < 3) {
            dArray[n3] = 0.0;
            for (int i = 0; i <= n2; ++i) {
                int n4 = n3;
                dArray[n4] = dArray[n4] + this.gradWave[n][i][n3];
            }
            int n5 = n3++;
            dArray[n5] = dArray[n5] * this.dt[n];
        }
        return dArray;
    }

    @Override
    public DW_Scheme getSubsetScheme(int[] nArray) {
        double[][][] dArrayArray = new double[nArray.length][][];
        double[] dArray = new double[nArray.length];
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (i != nArray[i]) continue;
            dArrayArray[n] = new double[this.gradWave[i].length][3];
            for (int j = 0; j < dArrayArray[n].length; ++j) {
                for (int k = 0; k < 3; ++k) {
                    dArrayArray[n][j][k] = this.gradWave[i][j][k];
                }
            }
            dArray[n] = this.dt[i];
            ++n;
        }
        return new GradientWaveform_Scheme(dArrayArray, dArray);
    }

    @Override
    public DW_Scheme gradOrder(int[] nArray) {
        double[][][] dArrayArray = new double[nArray.length][][];
        double[] dArray = new double[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            dArrayArray[i] = new double[this.gradWave[n].length][3];
            for (int j = 0; j < dArrayArray[i].length; ++j) {
                for (int k = 0; k < 3; ++k) {
                    dArrayArray[i][j][k] = this.gradWave[n][j][k];
                }
                dArray[i] = this.dt[n];
            }
        }
        return new GradientWaveform_Scheme(dArrayArray, dArray);
    }

    @Override
    public double getDuration() {
        double d = 0.0;
        for (int i = 0; i < this.gradWave.length; ++i) {
            double d2 = (double)this.gradWave[i].length * this.dt[i];
            if (!(d < d2)) continue;
            d = d2;
        }
        return d;
    }

    @Override
    public double[] getGradImpulse(int n, double d, double d2) {
        int n2;
        int n3;
        double[] dArray = new double[3];
        int n4 = (int)Math.floor(d2 / this.dt[n]);
        if (n4 == (n3 = (int)Math.floor(d / this.dt[n]))) {
            double d3 = d - d2;
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = this.gradWave[n][n4][i] * d3;
            }
            return dArray;
        }
        for (n2 = 0; n2 < dArray.length; ++n2) {
            dArray[n2] = 0.0;
        }
        for (n2 = 0; n2 < dArray.length; ++n2) {
            dArray[n2] = ((double)(n4 + 1) * this.dt[n] - d2) * this.gradWave[n][n4][n2];
            int n5 = n2;
            dArray[n5] = dArray[n5] + (d - (double)n3 * this.dt[n]) * this.gradWave[n][n3][n2];
        }
        if (n3 > n4 + 1) {
            for (n2 = n4; n2 < n3; ++n2) {
                for (int i = 0; i < dArray.length; ++i) {
                    int n6 = i;
                    dArray[n6] = dArray[n6] + this.gradWave[n][n2][i] * this.dt[n];
                }
            }
        }
        return dArray;
    }

    protected static GradientWaveform_Scheme readScheme(Vector<String> vector) {
        int n = vector.size();
        if (n == 0) {
            throw new LoggedException("no data in scheme file.");
        }
        double[][][] dArrayArray = new double[n][][];
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            String string = vector.get(i);
            Scanner scanner = new Scanner(string);
            int n2 = (int)scanner.nextDouble();
            dArray[i] = scanner.nextDouble();
            dArrayArray[i] = new double[n2][3];
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < 3; ++k) {
                    dArrayArray[i][j][k] = scanner.nextDouble();
                }
            }
        }
        return new GradientWaveform_Scheme(dArrayArray, dArray);
    }

    public static void main(String[] stringArray) {
        System.err.println("Testing generalised gradient scheme files");
        System.err.print("Reading scheme...");
        DW_Scheme dW_Scheme = DW_Scheme.readScheme("gen_test.scheme");
        System.err.println("done.");
        System.err.println("Checking b value calulation");
        int n = dW_Scheme.numMeasurements();
        int n2 = dW_Scheme.numZeroMeasurements();
        System.err.println("parent scheme expects " + n + " measurements, of which " + n2 + " are zero");
        System.err.println("b-values are as follows:");
        for (int i = 0; i < n; ++i) {
            System.err.println(i + ") " + dW_Scheme.getB_Value(i));
        }
    }
}

