/*
 * Decompiled with CFR 0.152.
 */
package imaging;

import data.DataSource;
import imaging.AnalyzeHeader;
import imaging.MetaImageHeader;
import imaging.Nifti1Dataset;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import misc.LoggedException;
import numerics.RealMatrix;

public abstract class ImageHeader {
    private static Logger logger = Logger.getLogger("camino.imaging.ImageHeader");

    public abstract int xDataDim();

    public abstract int yDataDim();

    public abstract int zDataDim();

    public abstract int[] getDataDims();

    public abstract double xVoxelDim();

    public abstract double yVoxelDim();

    public abstract double zVoxelDim();

    public abstract double[] getVoxelDims();

    public abstract int components();

    public abstract RealMatrix getVoxelToPhysicalTransform();

    public abstract DataSource getImageDataSource();

    public abstract double[][][][] readVolumeData();

    public double[][][] readSingleVolumeData() {
        double[][][][] dArray = this.readVolumeData();
        int n = this.xDataDim();
        int n2 = this.yDataDim();
        int n3 = this.zDataDim();
        double[][][] dArray2 = new double[n][n2][n3];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n3; ++k) {
                    dArray2[i][j][k] = dArray[i][j][k][0];
                }
            }
        }
        return dArray2;
    }

    protected abstract String getHeaderFilename();

    protected abstract String getDataFilename();

    public abstract ImageHeader writeScalarImage(double[][][] var1, String var2);

    public abstract ImageHeader writeVectorImage(double[][][][] var1, String var2);

    public abstract ImageHeader writeRGB_Image(int[][][] var1, int[][][] var2, int[][][] var3, String var4);

    public abstract ImageHeader writeTensorImage(double[][][][] var1, String var2);

    public abstract void setDataType(String var1);

    public abstract void setGzip(boolean var1);

    public RealMatrix getPhysicalToVoxelTransform() {
        int n;
        int n2;
        RealMatrix realMatrix = this.getVoxelToPhysicalTransform();
        RealMatrix realMatrix2 = new RealMatrix(4, 4);
        RealMatrix realMatrix3 = new RealMatrix(3, 3);
        RealMatrix realMatrix4 = new RealMatrix(3, 1);
        for (int i = 0; i < 3; ++i) {
            realMatrix4.entries[i][0] = realMatrix.entries[i][3];
            for (n2 = 0; n2 < 3; ++n2) {
                realMatrix3.entries[i][n2] = realMatrix.entries[i][n2];
            }
        }
        RealMatrix realMatrix5 = realMatrix3.inverse();
        for (n2 = 0; n2 < 3; ++n2) {
            for (n = 0; n < 3; ++n) {
                realMatrix2.entries[n2][n] = realMatrix5.entries[n2][n];
            }
        }
        realMatrix5.scale(-1.0);
        RealMatrix realMatrix6 = realMatrix5.product(realMatrix4);
        for (n = 0; n < 3; ++n) {
            realMatrix2.entries[n][3] = realMatrix6.entries[n][0];
        }
        realMatrix2.entries[3][3] = 1.0;
        return realMatrix2;
    }

    public final boolean sameDimensions(ImageHeader imageHeader) {
        if (this.xDataDim() != imageHeader.xDataDim() || this.yDataDim() != imageHeader.yDataDim() || this.zDataDim() != imageHeader.zDataDim()) {
            logger.info("Data dimensions differ between " + this.getHeaderFilename() + " and " + imageHeader.getHeaderFilename());
            return false;
        }
        if (this.xVoxelDim() != imageHeader.xVoxelDim() || this.yVoxelDim() != imageHeader.yVoxelDim() || this.zVoxelDim() != imageHeader.zVoxelDim()) {
            logger.info("Voxel dimensions differ between " + this.getHeaderFilename() + " and " + imageHeader.getHeaderFilename());
            return false;
        }
        return true;
    }

    public final boolean sameDimensions(int[] nArray, double[] dArray) {
        double d = 1.0E-5;
        if (this.xDataDim() != nArray[0] || this.yDataDim() != nArray[1] || this.zDataDim() != nArray[2]) {
            return false;
        }
        double[] dArray2 = this.getVoxelDims();
        for (int i = 0; i < 3; ++i) {
            if (!(Math.abs(dArray2[i] - dArray[i]) > d)) continue;
            return false;
        }
        return true;
    }

    public final boolean sameSpace(ImageHeader imageHeader) {
        if (!this.sameDimensions(imageHeader)) {
            return false;
        }
        RealMatrix realMatrix = this.getVoxelToPhysicalTransform();
        RealMatrix realMatrix2 = imageHeader.getVoxelToPhysicalTransform();
        double d = 1.0E-5;
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                if (!(Math.abs(realMatrix.entries[i][j] - realMatrix2.entries[i][j]) > d)) continue;
                logger.info("Different voxel to physical space transforms between " + this.getHeaderFilename() + " and " + imageHeader.getHeaderFilename());
                return false;
            }
        }
        return true;
    }

    public final boolean sameSpace(String string) {
        try {
            return this.sameSpace(ImageHeader.readHeader(string));
        }
        catch (IOException iOException) {
            logger.warning("Cannot read image " + string);
            return false;
        }
    }

    public static ImageHeader readHeader(String string) throws IOException {
        if (string == null) {
            throw new LoggedException("File name required to read image header (format determined by extension)");
        }
        if (AnalyzeHeader.getImageRoot(string) != null) {
            if (Nifti1Dataset.hdrIsNifti(string)) {
                return Nifti1Dataset.readHeader(string);
            }
            String string2 = AnalyzeHeader.getImageRoot(string);
            File file = new File(string2 + ".hdr");
            long l = file.length();
            return AnalyzeHeader.readHeader(string2 + ".hdr");
        }
        if (string.endsWith(".nii") || string.endsWith(".nii.gz")) {
            return Nifti1Dataset.readHeader(string);
        }
        if (string.endsWith(".mhd") || string.endsWith(".mha")) {
            return MetaImageHeader.readHeader(string);
        }
        throw new LoggedException("Can't find image for input file name " + string);
    }

    public static boolean imageExists(String string) {
        if (string == null) {
            return false;
        }
        if (string.endsWith(".nii") || string.endsWith(".nii.gz") || string.endsWith(".mha") || string.endsWith(".mhd")) {
            File file = new File(string);
            return file.exists();
        }
        return AnalyzeHeader.getImageRoot(string) != null;
    }
}

