/*
 * Decompiled with CFR 0.152.
 */
package imaging;

import imaging.DW_Scheme;
import imaging.SimulableScheme;
import imaging.TRSE_Scheme;
import java.text.DecimalFormat;
import java.util.Scanner;
import java.util.Vector;
import java.util.logging.Logger;
import misc.LoggedException;

public final class RectGradTRSE_Scheme
extends TRSE_Scheme
implements SimulableScheme {
    public static final String VERSION = "TRSE";
    private static final Logger logger = Logger.getLogger("camino.imaging.RectGradTRSE_Scheme");
    private final double[] blockStart = new double[4];
    private final double[] blockEnd = new double[4];

    protected RectGradTRSE_Scheme(double[][] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, double[] dArray6, double[] dArray7, double[] dArray8, double[] dArray9) {
        super(dArray, dArray2, dArray3, dArray4, dArray5, dArray6, dArray7, dArray8, dArray9);
    }

    protected RectGradTRSE_Scheme(double[][] dArray, RectGradTRSE_Scheme rectGradTRSE_Scheme) {
        super(dArray, rectGradTRSE_Scheme);
    }

    @Override
    public double getB_Value(int n) {
        double d = this.getModG(n);
        double d2 = this.getDel1(n);
        double d3 = this.getDel2(n);
        double d4 = this.getDel3(n);
        double d5 = this.getDel4(n);
        double d6 = this.getT_Del1(n);
        double d7 = this.getT_Del2(n);
        double d8 = this.getT_Del3(n);
        double d9 = this.getT_Del4(n);
        double d10 = 7.15644089825625E16 * d * d * (d2 * d2 * (-d6 + d8 - d2 / 3.0 + d3 - d4) + 2.0 * d2 * d3 * (d8 - d7) + d3 * d3 * (-d7 + d8 - d3 / 3.0 + d4) + 2.0 * d2 * d4 * (d7 - d8 + d4) + d3 * d4 * (2.0 * d7 - 2.0 * d8 + d4) + d4 * d4 * (d8 - d7 - d4));
        return d10;
    }

    private DW_Scheme flip(int n) {
        double[][] dArray = new double[this.numMeas][3];
        for (int i = 0; i < this.numMeas; ++i) {
            if (this.zero(i)) continue;
            dArray[i] = this.getG_Dir(i);
            dArray[i][n] = -dArray[i][n];
        }
        return new RectGradTRSE_Scheme(dArray, this);
    }

    @Override
    public DW_Scheme flipX() {
        return this.flip(0);
    }

    @Override
    public DW_Scheme flipY() {
        return this.flip(1);
    }

    @Override
    public DW_Scheme flipZ() {
        return this.flip(2);
    }

    @Override
    public DW_Scheme getSubsetScheme(int[] nArray) {
        int n = nArray.length;
        double[][] dArray = new double[n][3];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        double[] dArray4 = new double[n];
        double[] dArray5 = new double[n];
        double[] dArray6 = new double[n];
        double[] dArray7 = new double[n];
        double[] dArray8 = new double[n];
        double[] dArray9 = new double[n];
        for (int i = 0; i < n; ++i) {
            double[] dArray10 = this.getG_Dir(nArray[i]);
            dArray[i][0] = dArray10[0];
            dArray[i][1] = dArray10[1];
            dArray[i][2] = dArray10[2];
            dArray2[i] = this.getModG(nArray[i]);
            dArray4[i] = this.getT_Del1(nArray[i]);
            dArray3[i] = this.getDel1(nArray[i]);
            dArray6[i] = this.getT_Del2(nArray[i]);
            dArray5[i] = this.getDel2(nArray[i]);
            dArray7[i] = this.getDel3(nArray[i]);
            dArray8[i] = this.getT_Del4(nArray[i]);
            dArray9[i] = this.getTE(nArray[i]);
        }
        return new RectGradTRSE_Scheme(dArray, dArray2, dArray3, dArray4, dArray5, dArray6, dArray7, dArray8, dArray9);
    }

    @Override
    public DW_Scheme gradOrder(int[] nArray) {
        double[][] dArray = new double[this.numMeas][3];
        for (int i = 0; i < this.numMeas; ++i) {
            double[] dArray2 = this.getG_Dir(i);
            dArray[i][0] = dArray2[nArray[0]];
            dArray[i][1] = dArray2[nArray[1]];
            dArray[i][2] = dArray2[nArray[2]];
        }
        return new RectGradTRSE_Scheme(dArray, this);
    }

    @Override
    public double[] getGradImpulse(int n, double d, double d2) {
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        if (d2 > d) {
            throw new LoggedException("tLast (" + d2 + ") must be < t (" + d + ")");
        }
        if (d2 == d) {
            return dArray;
        }
        if (this.zero(n)) {
            return dArray;
        }
        this.blockStart[0] = this.getT_Del1(n);
        this.blockStart[1] = this.getT_Del2(n);
        this.blockStart[2] = this.getT_Del3(n);
        this.blockStart[3] = this.getT_Del4(n);
        this.blockEnd[0] = this.blockStart[0] + this.getDel1(n);
        this.blockEnd[1] = this.blockStart[1] + this.getDel2(n);
        this.blockEnd[2] = this.blockStart[2] + this.getDel3(n);
        this.blockEnd[3] = this.blockStart[3] + this.getDel4(n);
        if (d2 > this.blockEnd[3]) {
            return dArray;
        }
        double d3 = 1.0;
        double d4 = this.getModG(n);
        for (int i = 0; i < 4; ++i) {
            int n2;
            double d5;
            if (i > 1) {
                d3 = -1.0;
            }
            if (d < this.blockStart[i]) {
                return dArray2;
            }
            if (d2 > this.blockEnd[i]) continue;
            if (d2 < this.blockStart[i]) {
                d5 = d < this.blockEnd[i] ? d - this.blockStart[i] : this.blockEnd[i] - this.blockStart[i];
                for (n2 = 0; n2 < 3; ++n2) {
                    int n3 = n2;
                    dArray2[n3] = dArray2[n3] + d3 * d4 * this.gDir[n][n2] * d5;
                }
                continue;
            }
            d5 = d < this.blockEnd[i] ? d - d2 : this.blockEnd[i] - d2;
            for (n2 = 0; n2 < 3; ++n2) {
                int n4 = n2;
                dArray2[n4] = dArray2[n4] + d3 * d4 * this.gDir[n][n2] * d5;
            }
        }
        return dArray2;
    }

    @Override
    public double getDuration() {
        double d = 0.0;
        for (int i = 0; i < this.numMeas; ++i) {
            double d2 = this.getTE(i);
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    protected static RectGradTRSE_Scheme readScheme(Vector<String> vector) {
        int n = vector.size();
        if (n == 0) {
            throw new LoggedException("No measurements in scheme file");
        }
        double[][] dArray = new double[n][3];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        double[] dArray4 = new double[n];
        double[] dArray5 = new double[n];
        double[] dArray6 = new double[n];
        double[] dArray7 = new double[n];
        double[] dArray8 = new double[n];
        double[] dArray9 = new double[n];
        double[] dArray10 = new double[n];
        for (int i = 0; i < n; ++i) {
            Scanner scanner = new Scanner(vector.get(i));
            dArray[i][0] = scanner.nextDouble();
            dArray[i][1] = scanner.nextDouble();
            dArray[i][2] = scanner.nextDouble();
            dArray2[i] = scanner.nextDouble();
            dArray4[i] = scanner.nextDouble();
            dArray3[i] = scanner.nextDouble();
            dArray6[i] = scanner.nextDouble();
            dArray5[i] = scanner.nextDouble();
            dArray7[i] = scanner.nextDouble();
            dArray9[i] = scanner.nextDouble();
            dArray10[i] = scanner.nextDouble();
            scanner.close();
            if (dArray2[i] != 0.0 || dArray[i][0] == 0.0 && dArray[i][1] == 0.0 && dArray[i][2] == 0.0) continue;
            logger.info("Zero diffusion weighting in measurement " + i + ", setting gradient direction to zero");
            dArray[i][0] = 0.0;
            dArray[i][1] = 0.0;
            dArray[i][2] = 0.0;
        }
        return new RectGradTRSE_Scheme(dArray, dArray2, dArray3, dArray4, dArray5, dArray6, dArray7, dArray9, dArray10);
    }

    public String toString() {
        DecimalFormat decimalFormat = new DecimalFormat("   0.000000;  -0.000000");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("#Twice-refocused scheme with rectangular gradient pulses\n");
        stringBuffer.append("#g_x\tg_y\tg_z\t|g|\tt_del1\tdel1\tt_del2\tdel2\tdel3\tt_del4\tTE\n");
        stringBuffer.append("VERSION: TRSE");
        stringBuffer.append("\n");
        for (int i = 0; i < this.numMeas; ++i) {
            double[] dArray = this.getG_Dir(i);
            stringBuffer.append(decimalFormat.format(dArray[0]));
            stringBuffer.append(decimalFormat.format(dArray[1]));
            stringBuffer.append(decimalFormat.format(dArray[2]));
            stringBuffer.append(decimalFormat.format(this.getModG(i)));
            stringBuffer.append(decimalFormat.format(this.getT_Del1(i)));
            stringBuffer.append(decimalFormat.format(this.getDel1(i)));
            stringBuffer.append(decimalFormat.format(this.getT_Del2(i)));
            stringBuffer.append(decimalFormat.format(this.getDel2(i)));
            stringBuffer.append(decimalFormat.format(this.getDel3(i)));
            stringBuffer.append(decimalFormat.format(this.getT_Del4(i)));
            stringBuffer.append(decimalFormat.format(this.getTE(i)));
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }
}

