/*
 * Decompiled with CFR 0.152.
 */
package imaging;

import imaging.DW_Scheme;
import imaging.SimulableScheme;
import java.util.logging.Logger;
import misc.LoggedException;

public abstract class StejskalTannerScheme
extends DW_Scheme
implements SimulableScheme {
    private static final Logger logger = Logger.getLogger("camino.imaging.StejskalTannerScheme");
    private final double[] modG;
    private final double[] bigDel;
    private final double[] smallDel;
    private final double[] TE;

    protected StejskalTannerScheme(double[][] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5) {
        super(dArray);
        this.modG = new double[this.numMeas];
        this.bigDel = new double[this.numMeas];
        this.smallDel = new double[this.numMeas];
        this.TE = new double[this.numMeas];
        System.arraycopy(dArray2, 0, this.modG, 0, this.numMeas);
        System.arraycopy(dArray3, 0, this.bigDel, 0, this.numMeas);
        System.arraycopy(dArray4, 0, this.smallDel, 0, this.numMeas);
        System.arraycopy(dArray5, 0, this.TE, 0, this.numMeas);
    }

    protected StejskalTannerScheme(double[][] dArray, StejskalTannerScheme stejskalTannerScheme) {
        this(dArray, stejskalTannerScheme.modG, stejskalTannerScheme.bigDel, stejskalTannerScheme.smallDel, stejskalTannerScheme.TE);
        if (this.numMeas != stejskalTannerScheme.numMeas) {
            throw new LoggedException("Error in scheme copy construction, number of measurements was " + this.numMeas + ", expected " + stejskalTannerScheme.numMeas);
        }
    }

    public final double getMeanNonZeroModQ() {
        double d = 0.0;
        for (int i = 0; i < this.numMeas; ++i) {
            if (this.zero(i)) continue;
            d += this.getModQ(i);
        }
        return d / (double)(this.numMeas - this.numZeroMeas);
    }

    public final double[][] getNormNonZeroQs() {
        double[][] dArray = new double[this.numMeas - this.numZeroMeas][3];
        int n = 0;
        double d = this.getMeanNonZeroModQ();
        for (int i = 0; i < this.numMeas; ++i) {
            if (this.zero(i)) continue;
            double d2 = this.getModQ(i);
            double[] dArray2 = this.getG_Dir(i);
            for (int j = 0; j < 3; ++j) {
                dArray[n][j] = dArray2[j] * d2 / d;
            }
            ++n;
        }
        return dArray;
    }

    public final double[][] getNonZeroQs() {
        double[][] dArray = new double[this.numMeas - this.numZeroMeas][3];
        int n = 0;
        for (int i = 0; i < this.numMeas; ++i) {
            if (this.zero(i)) continue;
            double d = this.getModQ(i);
            double[] dArray2 = this.getG_Dir(i);
            for (int j = 0; j < 3; ++j) {
                dArray[n][j] = d * dArray2[j];
            }
            ++n;
        }
        return dArray;
    }

    public final double[][] getNonZeroGs() {
        double[][] dArray = new double[this.numMeas - this.numZeroMeas][3];
        int n = 0;
        for (int i = 0; i < this.numMeas; ++i) {
            if (this.zero(i)) continue;
            double[] dArray2 = this.getG_Dir(i);
            for (int j = 0; j < 3; ++j) {
                dArray[n][j] = this.modG[i] * dArray2[j];
            }
            ++n;
        }
        return dArray;
    }

    public final double[] getNonZeroBigDeltas() {
        return this.getNonZeroParam(this.bigDel);
    }

    public final double[] getNonZeroSmallDeltas() {
        return this.getNonZeroParam(this.smallDel);
    }

    public final double[] getNonZeroModGs() {
        return this.getNonZeroParam(this.modG);
    }

    public final double[] getNonZeroTEs() {
        return this.getNonZeroParam(this.TE);
    }

    public final double getDelta(int n) {
        return this.smallDel[n];
    }

    public final double getDELTA(int n) {
        return this.bigDel[n];
    }

    public final double getModG(int n) {
        return this.modG[n];
    }

    public final double[] getG(int n) {
        double[] dArray = this.getG_Dir(n);
        int n2 = 0;
        while (n2 < 3) {
            int n3 = n2++;
            dArray[n3] = dArray[n3] * this.modG[n];
        }
        return dArray;
    }

    public final double[] getQ(int n) {
        double[] dArray = this.getG_Dir(n);
        double d = this.getModQ(n);
        int n2 = 0;
        while (n2 < 3) {
            int n3 = n2++;
            dArray[n3] = dArray[n3] * d;
        }
        return dArray;
    }

    public final double getTE(int n) {
        return this.TE[n];
    }

    public final double getModQ(int n) {
        return 2.6751525E8 * this.smallDel[n] * this.modG[n];
    }

    @Override
    public abstract double[] getGradImpulse(int var1, double var2, double var4);

    @Override
    public abstract double getDuration();
}

