/*
 * Decompiled with CFR 0.152.
 */
package inverters;

import imaging.DW_Scheme;
import inverters.BallStickFitter;
import inverters.DiffusionInversion;
import inverters.LinearDT_Inversion;
import misc.DT;
import misc.LoggedException;
import numerics.Rotations;
import numerics.Vector3D;

public class BallStickInversion
extends DiffusionInversion {
    private BallStickFitter fitter;
    private LinearDT_Inversion linearInv;

    public BallStickInversion(DW_Scheme dW_Scheme) {
        this.ip = dW_Scheme;
        try {
            this.fitter = new BallStickFitter(dW_Scheme);
        }
        catch (Exception exception) {
            throw new LoggedException(exception);
        }
        this.linearInv = new LinearDT_Inversion(dW_Scheme);
    }

    @Override
    public double[] invert(double[] dArray) {
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            if (dArray[i] > 0.0) continue;
            d = 6.0;
        }
        try {
            this.fitter.newDepVals(dArray);
            this.fitter.minimise();
        }
        catch (Exception exception) {
            System.err.println(exception);
            d = 2.0;
            double[] dArray2 = new double[7];
            double[] dArray3 = this.linearInv.invert(dArray);
            DT dT = new DT(dArray3[2], dArray3[3], dArray3[4], dArray3[5], dArray3[6], dArray3[7]);
            double[][] dArray4 = dT.sortedEigenSystem();
            double d2 = dT.fa();
            dArray2[0] = d;
            dArray2[1] = dArray3[1];
            dArray2[2] = dT.trace() / 3.0;
            dArray2[3] = dT.fa();
            dArray2[4] = dArray4[1][0];
            dArray2[5] = dArray4[2][0];
            dArray2[6] = dArray4[3][0];
            return dArray2;
        }
        double[] dArray5 = this.fitter.getParameters();
        Vector3D vector3D = Rotations.rotateVector(Rotations.X_AXIS, Rotations.Y_AXIS, dArray5[4]);
        vector3D = Rotations.rotateVector(vector3D, Rotations.Z_AXIS, dArray5[5]);
        double[] dArray6 = new double[]{d, dArray5[1], dArray5[2], dArray5[3], vector3D.x, vector3D.y, vector3D.z};
        return dArray6;
    }

    @Override
    public int itemsPerVoxel() {
        return 7;
    }
}

