/*
 * Decompiled with CFR 0.152.
 */
package inverters;

import imaging.DW_Scheme;
import inverters.DT_Inversion;
import inverters.DiffTensorFitter;
import inverters.DiffTensorMinPackFitter;
import inverters.DiffTensorUnConFitter;
import inverters.LinearDT_Inversion;
import inverters.ModelIndex;
import misc.DT;
import misc.LoggedException;

public class NonLinearDT_Inversion
extends DT_Inversion {
    protected DiffTensorFitter fitter;
    protected LinearDT_Inversion ldti;
    int testindex = 0;

    public NonLinearDT_Inversion(DW_Scheme dW_Scheme) {
        this.init(dW_Scheme, ModelIndex.NLDT_POS);
    }

    public NonLinearDT_Inversion(DW_Scheme dW_Scheme, ModelIndex modelIndex) {
        this.init(dW_Scheme, modelIndex);
    }

    protected void init(DW_Scheme dW_Scheme, ModelIndex modelIndex) {
        block5: {
            this.ip = dW_Scheme;
            this.ldti = new LinearDT_Inversion(this.ip);
            double[][] dArray = this.ip.getNonZeroG_Dirs();
            double[] dArray2 = this.ip.getNonZeroB_Values();
            int n = this.ip.numZeroMeasurements();
            double[] dArray3 = new double[this.ip.numMeasurements() - n];
            try {
                if (modelIndex == ModelIndex.NLDT_POS) {
                    this.fitter = new DiffTensorFitter(dArray, dArray3, dArray2, n);
                    break block5;
                }
                if (modelIndex == ModelIndex.NLDT) {
                    this.fitter = new DiffTensorUnConFitter(dArray, dArray3, dArray2, n);
                    break block5;
                }
                if (modelIndex == ModelIndex.NLDT_MINPACK) {
                    this.fitter = new DiffTensorMinPackFitter(dArray, dArray3, dArray2, n);
                    break block5;
                }
                throw new LoggedException("Unknown nonlinear DT inversion " + (Object)((Object)modelIndex));
            }
            catch (Exception exception) {
                throw new LoggedException(exception);
            }
        }
    }

    @Override
    public double[] invert(double[] dArray) {
        double[] dArray2 = this.ldti.invert(dArray);
        double d = dArray2[0];
        double[] dArray3 = this.ip.normalizeData(dArray);
        try {
            this.fitter.newDepVals(dArray3);
            this.fitter.setStartPoint(dArray2);
            this.fitter.minimise();
        }
        catch (Exception exception) {
            LoggedException.logExceptionWarning(exception, Thread.currentThread().getName());
            d = 2.0;
        }
        DT dT = this.fitter.getDiffTensor();
        ++this.testindex;
        double[] dArray4 = dT.getComponents();
        double[] dArray5 = new double[8];
        dArray5[0] = d;
        dArray5[1] = dArray2[1];
        for (int i = 0; i < 6; ++i) {
            dArray5[i + 2] = dArray4[i];
        }
        return dArray5;
    }
}

