/*
 * Decompiled with CFR 0.152.
 */
package inverters;

import imaging.DW_Scheme;
import inverters.DT_Inversion;
import inverters.DiffTensorFitter;
import inverters.DiffTensorUnConFitter;
import inverters.LinearDT_Inversion;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import misc.DT;
import misc.LoggedException;
import optimizers.MarquardtMinimiserException;
import tools.ArrayOps;
import tools.CL_Initializer;

public class RestoreDT_Inversion
extends DT_Inversion {
    protected DiffTensorFitter fitter;
    protected LinearDT_Inversion ldti;
    protected double sigma;
    protected double[][] gNoZeros;
    protected double[] bValues;
    protected int M;
    protected int fitterIndex;
    private final double MADFACTOR = 1.4826;
    private final double MAXRESTHRESH = 3.0;
    private final int MAXITERATIONS = 100;
    private final double RESCHANGETHRESH = 0.001;
    private int[] outlierHist;
    private DataOutputStream outlierMap;

    public RestoreDT_Inversion(DW_Scheme dW_Scheme, double d) {
        this.ip = dW_Scheme;
        this.sigma = d;
        this.init(this.ip, 4);
    }

    public RestoreDT_Inversion(DW_Scheme dW_Scheme, double d, int n) {
        this.ip = dW_Scheme;
        this.sigma = d;
        this.init(this.ip, n);
    }

    protected void init(DW_Scheme dW_Scheme, int n) {
        this.ip = dW_Scheme;
        this.fitterIndex = n;
        this.ldti = new LinearDT_Inversion(this.ip);
        this.M = this.ip.numZeroMeasurements();
        this.bValues = this.ip.getNonZeroB_Values();
        this.gNoZeros = this.ip.getNonZeroG_Dirs();
        double[] dArray = new double[this.ip.numMeasurements() - this.M];
        this.fitter = this.getFitter(this.gNoZeros, dArray, this.bValues, this.M, this.fitterIndex);
        this.outlierHist = new int[this.gNoZeros.length];
        if (CL_Initializer.outlierMapFile != null) {
            try {
                this.outlierMap = new DataOutputStream(new FileOutputStream(CL_Initializer.outlierMapFile));
            }
            catch (FileNotFoundException fileNotFoundException) {
                logger.warning("" + fileNotFoundException);
            }
            catch (IOException iOException) {
                logger.warning("" + iOException);
            }
        }
    }

    @Override
    public double[] invert(double[] dArray) {
        double[] dArray2;
        DT dT;
        double d;
        block19: {
            d = 0.0;
            double[] dArray3 = this.ldti.invert(dArray);
            double[] dArray4 = new double[6];
            for (int i = 0; i < dArray4.length; ++i) {
                dArray4[i] = dArray3[i + 2];
            }
            double[] dArray5 = this.ip.normalizeData(dArray);
            double d2 = this.ip.geoMeanZeroMeas(dArray);
            double d3 = this.sigma / d2;
            dT = new DT(dArray3[2], dArray3[3], dArray3[4], dArray3[5], dArray3[6], dArray3[7]);
            try {
                this.fitter.newDepVals(dArray5);
                this.fitter.setInitParams(dArray4);
                for (int i = 1; i <= dArray5.length; ++i) {
                    this.fitter.setSig(i, d3);
                }
                this.fitter.minimise();
                dT = this.fitter.getDiffTensor();
                dArray2 = this.fitter.getResiduals();
                double d4 = ArrayOps.max(dArray2);
                if (d4 > 3.0 * d3) {
                    int[] nArray;
                    boolean bl;
                    int n;
                    Object object;
                    double d5 = 0.0;
                    for (int i = 0; Math.abs(d5 - d4) > 0.001 * d4 && i < 100; ++i) {
                        d5 = d4;
                        double d6 = ArrayOps.median(dArray2);
                        object = new double[dArray2.length];
                        for (int j = 0; j < ((double[])object).length; ++j) {
                            object[j] = Math.abs(dArray2[j] - d6);
                        }
                        double d7 = 1.4826 * ArrayOps.median(object);
                        this.fitter.newDepVals(dArray5);
                        this.fitter.setInitParams(dArray4);
                        for (n = 1; n <= dArray5.length; ++n) {
                            this.fitter.setSig(n, Math.sqrt(dArray2[n - 1] * dArray2[n - 1] + d7 * d7));
                        }
                        this.fitter.minimise();
                        dArray2 = this.fitter.getResiduals();
                        d4 = ArrayOps.max(dArray2);
                    }
                    boolean bl2 = bl = Math.abs(d5 - d4) < 0.001 * d4;
                    if (!bl) {
                        logger.info("Maximum iterations reached without convergence. Final tensor:\n\t" + dT);
                        d = 2.0;
                    }
                    if ((nArray = this.getOutliers(dArray2, d3)).length > dArray2.length - 6) {
                        logger.info("Too many outliers.  Outputting linearly fitted DT.");
                        dT = new DT(dArray3[2], dArray3[3], dArray3[4], dArray3[5], dArray3[6], dArray3[7]);
                        d = 2.0;
                    } else {
                        object = new double[this.gNoZeros.length - nArray.length][3];
                        double[] dArray6 = new double[dArray5.length - nArray.length];
                        double[] dArray7 = new double[dArray5.length - nArray.length];
                        n = 0;
                        int n2 = 0;
                        for (int i = 0; i < dArray2.length; ++i) {
                            if (n2 < nArray.length && i == nArray[n2]) {
                                ++n2;
                                continue;
                            }
                            object[n][0] = this.gNoZeros[i][0];
                            object[n][1] = this.gNoZeros[i][1];
                            object[n][2] = this.gNoZeros[i][2];
                            dArray6[n] = dArray5[i];
                            dArray7[n] = this.bValues[i];
                            ++n;
                        }
                        DiffTensorFitter diffTensorFitter = this.getFitter((double[][])object, dArray6, dArray7, this.M, this.fitterIndex);
                        diffTensorFitter.setInitParams(dArray4);
                        diffTensorFitter.minimise();
                        dT = diffTensorFitter.getDiffTensor();
                    }
                    if (this.outlierMap != null) {
                        this.outputOutlierMap(nArray);
                    }
                    if (d == 0.0) {
                        d = 1000 + nArray.length;
                    }
                    for (int i = 0; i < nArray.length; ++i) {
                        int n3 = nArray[i];
                        this.outlierHist[n3] = this.outlierHist[n3] + 1;
                    }
                } else if (this.outlierMap != null) {
                    this.outputOutlierMap(new int[0]);
                }
            }
            catch (MarquardtMinimiserException marquardtMinimiserException) {
                logger.info(marquardtMinimiserException.toString() + "Fitting failed.  Outputting best DT found, which may be affected by outliers.");
                d = 2.0;
                if (this.outlierMap == null) break block19;
                this.outputOutlierMap(new int[0]);
            }
        }
        dArray2 = dT.getComponents();
        double[] dArray8 = new double[8];
        dArray8[0] = d;
        double d8 = this.ip.geoMeanZeroMeas(dArray);
        dArray8[1] = d8 > 0.0 ? Math.log(d8) : 0.0;
        for (int i = 0; i < 6; ++i) {
            dArray8[i + 2] = dArray2[i];
        }
        return dArray8;
    }

    @Override
    public void close() {
        System.err.println("Outlier histogram:");
        for (int i = 0; i < this.outlierHist.length; ++i) {
            System.err.println(i + " : " + this.outlierHist[i]);
        }
        if (this.outlierMap != null) {
            try {
                this.outlierMap.close();
            }
            catch (Exception exception) {
                logger.warning("" + exception);
            }
        }
    }

    @Override
    public void background() {
        if (this.outlierMap != null) {
            this.outputOutlierMap(new int[0]);
        }
    }

    protected int[] getOutliers(double[] dArray, double d) {
        int n = 0;
        for (int i = 0; i < dArray.length; ++i) {
            if (!(dArray[i] > 3.0 * d)) continue;
            ++n;
        }
        int[] nArray = new int[n];
        int n2 = 0;
        for (int i = 0; i < dArray.length; ++i) {
            if (!(dArray[i] > 3.0 * d)) continue;
            nArray[n2] = i;
            ++n2;
        }
        return nArray;
    }

    protected void outputOutlierMap(int[] nArray) {
        int n = 0;
        try {
            for (int i = 0; i < this.gNoZeros.length; ++i) {
                if (n < nArray.length && i == nArray[n]) {
                    this.outlierMap.writeByte(1);
                    ++n;
                    continue;
                }
                this.outlierMap.writeByte(0);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new LoggedException(fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new LoggedException(iOException);
        }
    }

    protected DiffTensorFitter getFitter(double[][] dArray, double[] dArray2, double[] dArray3, int n, int n2) {
        DiffTensorFitter diffTensorFitter = null;
        try {
            diffTensorFitter = n2 == 4 ? new DiffTensorUnConFitter(dArray, dArray2, dArray3, n) : new DiffTensorFitter(dArray, dArray2, dArray3, n);
        }
        catch (MarquardtMinimiserException marquardtMinimiserException) {
            LoggedException.logExceptionSevere(marquardtMinimiserException, Thread.currentThread().getName());
            System.exit(1);
        }
        return diffTensorFitter;
    }
}

