/*
 * Decompiled with CFR 0.152.
 */
package inverters;

import inverters.TwoTensorFitter;
import misc.DT;
import optimizers.MarquardtMinimiserException;

public class TwoTensorCholFitter
extends TwoTensorFitter {
    public TwoTensorCholFitter() {
    }

    public TwoTensorCholFitter(double[][] dArray, double[] dArray2, double[] dArray3, int n) throws MarquardtMinimiserException {
        this.noParams = 13;
        this.dt1StartIndex = 1;
        this.dt2StartIndex = 7;
        this.mixParIndex = 13;
        this.initialize(dArray, dArray2, dArray3, n);
    }

    @Override
    protected void insertTensorParamDerivs(double[] dArray, double[] dArray2, double[] dArray3, double d, double d2, double d3, double d4) {
        double d5 = dArray3[0] * dArray2[this.dt1StartIndex] + dArray3[1] * dArray2[this.dt1StartIndex + 1] + dArray3[2] * dArray2[this.dt1StartIndex + 2];
        double d6 = dArray3[1] * dArray2[this.dt1StartIndex + 3] + dArray3[2] * dArray2[this.dt1StartIndex + 4];
        double d7 = dArray3[2] * dArray2[this.dt1StartIndex + 5];
        double d8 = dArray3[0] * dArray2[this.dt2StartIndex] + dArray3[1] * dArray2[this.dt2StartIndex + 1] + dArray3[2] * dArray2[this.dt2StartIndex + 2];
        double d9 = dArray3[1] * dArray2[this.dt2StartIndex + 3] + dArray3[2] * dArray2[this.dt2StartIndex + 4];
        double d10 = dArray3[2] * dArray2[this.dt2StartIndex + 5];
        TwoTensorCholFitter.insertCholDerivs(dArray, d4, this.dt1StartIndex, dArray3, d5, d6, d7, d3, d);
        TwoTensorCholFitter.insertCholDerivs(dArray, d4, this.dt2StartIndex, dArray3, d8, d9, d10, 1.0 - d3, d2);
    }

    @Override
    protected void insertOtherDerivs(double[] dArray, double[] dArray2, double d, double d2, double d3) {
        dArray[this.mixParIndex] = 2.0 * Math.cos(dArray2[this.mixParIndex]) * Math.sin(dArray2[this.mixParIndex]) * (d - d2);
    }

    @Override
    protected DT getDT1(double[] dArray) {
        return TwoTensorCholFitter.getDT_Chol(dArray, this.dt1StartIndex);
    }

    @Override
    protected DT getDT2(double[] dArray) {
        return TwoTensorCholFitter.getDT_Chol(dArray, this.dt2StartIndex);
    }

    @Override
    protected double getP(double[] dArray) {
        double d = Math.sin(dArray[this.mixParIndex]);
        return d * d;
    }

    @Override
    protected double[] dt1ToParams(DT dT) {
        return TwoTensorCholFitter.getCholParams(dT);
    }

    @Override
    protected double[] dt2ToParams(DT dT) {
        return TwoTensorCholFitter.getCholParams(dT);
    }

    @Override
    protected double mixParToParam(double d) {
        return Math.asin(Math.sqrt(d));
    }
}

