/*
 * Decompiled with CFR 0.152.
 */
package inverters;

import inverters.ModelIndex;
import inverters.TensorModelFitter;
import inverters.TwoTensorAxiSymFitter;
import inverters.TwoTensorAxiSymFixMP_Fitter;
import inverters.TwoTensorCholFitter;
import inverters.TwoTensorCholFixMP_Fitter;
import inverters.TwoTensorOneAxiSymFitter;
import inverters.TwoTensorOneAxiSymFixMP_Fitter;
import misc.DT;
import optimizers.MarquardtMinimiserException;

public class TwoTensorFitter
extends TensorModelFitter {
    protected int dt1StartIndex;
    protected int dt2StartIndex;
    protected int mixParIndex;

    public TwoTensorFitter() {
    }

    public TwoTensorFitter(double[][] dArray, double[] dArray2, double[] dArray3, int n) throws MarquardtMinimiserException {
        this.noParams = 13;
        this.dt1StartIndex = 2;
        this.dt2StartIndex = 8;
        this.mixParIndex = 1;
        this.initialize(dArray, dArray2, dArray3, n);
    }

    @Override
    protected void initAs() {
        double d = 0.5;
        double[] dArray = this.getParamArray(this.initParams1(), this.initParams2(), d);
        for (int i = 0; i < dArray.length; ++i) {
            this.a[i] = dArray[i];
        }
    }

    protected double[] initParams1() {
        double d = 2.1E-9;
        DT dT = new DT(d / 3.0, 0.0, 0.0, d / 3.0, 0.0, d / 3.0);
        return this.dt1ToParams(dT);
    }

    protected double[] initParams2() {
        double d = 2.4E-9;
        DT dT = new DT(d / 3.0, 0.0, 0.0, d / 3.0, 0.0, d / 3.0);
        return this.dt2ToParams(dT);
    }

    public void setStartFromSingleDT(DT dT) {
        double[] dArray = this.getStartParamsFromSingleDT(dT);
        for (int i = 1; i <= this.noParams; ++i) {
            this.a[i] = dArray[i];
        }
    }

    protected double[] getStartParamsFromSingleDT(DT dT) {
        double[] dArray = TwoTensorFitter.fsAndBetasFromSingleDT(dT);
        double[] dArray2 = new double[]{dArray[0], dArray[1], dArray[2], dArray[6]};
        double[] dArray3 = this.fAndBetaToParams1(dArray2);
        dArray2[0] = dArray[3];
        dArray2[1] = dArray[4];
        dArray2[2] = dArray[5];
        dArray2[3] = dArray[7];
        double[] dArray4 = this.fAndBetaToParams2(dArray2);
        double d = 0.5;
        return this.getParamArray(dArray3, dArray4, d);
    }

    protected double[] fAndBetaToParams1(double[] dArray) {
        DT dT = TwoTensorFitter.fAndBetaToDT(dArray);
        return this.dt1ToParams(dT);
    }

    protected double[] fAndBetaToParams2(double[] dArray) {
        DT dT = TwoTensorFitter.fAndBetaToDT(dArray);
        return this.dt2ToParams(dT);
    }

    protected double[] getParamArray(double[] dArray, double[] dArray2, double d) {
        int n;
        double[] dArray3 = new double[this.noParams + 1];
        for (n = 0; n < dArray.length; ++n) {
            dArray3[this.dt1StartIndex + n] = dArray[n];
        }
        for (n = 0; n < dArray2.length; ++n) {
            dArray3[this.dt2StartIndex + n] = dArray2[n];
        }
        this.insertMixPar(dArray3, d);
        return dArray3;
    }

    protected void insertMixPar(double[] dArray, double d) {
        dArray[this.mixParIndex] = this.mixParToParam(d);
    }

    protected double[] dt1ToParams(DT dT) {
        return TwoTensorFitter.getPosDiagParams(dT);
    }

    protected double[] dt2ToParams(DT dT) {
        return TwoTensorFitter.getPosDiagParams(dT);
    }

    protected double mixParToParam(double d) {
        return Math.sqrt((1.0 - d) / d);
    }

    public DT getDT1() {
        return this.getDT1(this.a);
    }

    public DT getDT2() {
        return this.getDT2(this.a);
    }

    public double getMix() {
        return this.getP(this.a);
    }

    @Override
    protected double yfit(double[] dArray, int n) {
        double[] dArray2 = TwoTensorFitter.getG(this.x, n);
        DT dT = this.getDT1(dArray);
        double d = Math.exp(-this.bValues[n] * dT.contractBy(dArray2));
        DT dT2 = this.getDT2(dArray);
        double d2 = Math.exp(-this.bValues[n] * dT2.contractBy(dArray2));
        double d3 = this.getP(dArray);
        double d4 = d3 * d + (1.0 - d3) * d2;
        return d4;
    }

    @Override
    protected double[] dydas(double[] dArray, int n) {
        double[] dArray2 = new double[this.ma + 1];
        double[] dArray3 = TwoTensorFitter.getG(this.x, n);
        DT dT = this.getDT1(dArray);
        double d = Math.exp(-this.bValues[n] * dT.contractBy(dArray3));
        DT dT2 = this.getDT2(dArray);
        double d2 = Math.exp(-this.bValues[n] * dT2.contractBy(dArray3));
        double d3 = this.getP(dArray);
        this.insertTensorParamDerivs(dArray2, dArray, dArray3, d, d2, d3, this.bValues[n]);
        this.insertOtherDerivs(dArray2, dArray, d, d2, d3);
        boolean bl = false;
        if (bl) {
            double[] dArray4 = this.dydasNumerical(dArray, n);
            System.out.println("i = " + n);
            for (int i = 0; i < dArray2.length; ++i) {
                System.out.print(dArray[i] + " " + dArray2[i] + " " + dArray4[i] + "  :  ");
            }
            System.out.println();
        }
        return dArray2;
    }

    protected void insertTensorParamDerivs(double[] dArray, double[] dArray2, double[] dArray3, double d, double d2, double d3, double d4) {
        double[] dArray4 = new double[]{dArray3[0] * dArray3[0], 2.0 * dArray3[0] * dArray3[1], 2.0 * dArray3[0] * dArray3[2], dArray3[1] * dArray3[1], 2.0 * dArray3[1] * dArray3[2], dArray3[2] * dArray3[2]};
        TwoTensorFitter.insertPosDiagDerivs(dArray, d4, this.dt1StartIndex, dArray4, dArray2[this.dt1StartIndex], dArray2[this.dt1StartIndex + 3], dArray2[this.dt1StartIndex + 5], d3, d);
        TwoTensorFitter.insertPosDiagDerivs(dArray, d4, this.dt2StartIndex, dArray4, dArray2[this.dt2StartIndex], dArray2[this.dt2StartIndex + 3], dArray2[this.dt2StartIndex + 5], 1.0 - d3, d2);
    }

    protected void insertOtherDerivs(double[] dArray, double[] dArray2, double d, double d2, double d3) {
        dArray[this.mixParIndex] = -2.0 * dArray2[this.mixParIndex] * (d3 * d3) * (d - d2);
    }

    protected DT getDT1(double[] dArray) {
        return TwoTensorFitter.getDT_PosDiag(dArray, this.dt1StartIndex);
    }

    protected DT getDT2(double[] dArray) {
        return TwoTensorFitter.getDT_PosDiag(dArray, this.dt2StartIndex);
    }

    protected double getP(double[] dArray) {
        return TwoTensorFitter.invX2P1(dArray[this.mixParIndex]);
    }

    public static TwoTensorFitter getIndexedTwoTensorFitter(double[][] dArray, double[] dArray2, double[] dArray3, int n, ModelIndex modelIndex) throws MarquardtMinimiserException {
        if (modelIndex == ModelIndex.CYLCYL) {
            return new TwoTensorAxiSymFitter(dArray, dArray2, dArray3, n);
        }
        if (modelIndex == ModelIndex.CYLCYL_EQ) {
            return new TwoTensorAxiSymFixMP_Fitter(dArray, dArray2, dArray3, n);
        }
        if (modelIndex == ModelIndex.POSPOS) {
            return new TwoTensorCholFitter(dArray, dArray2, dArray3, n);
        }
        if (modelIndex == ModelIndex.POSPOS_EQ) {
            return new TwoTensorCholFixMP_Fitter(dArray, dArray2, dArray3, n);
        }
        if (modelIndex == ModelIndex.POSCYL) {
            return new TwoTensorOneAxiSymFitter(dArray, dArray2, dArray3, n);
        }
        if (modelIndex == ModelIndex.POSCYL_EQ) {
            return new TwoTensorOneAxiSymFixMP_Fitter(dArray, dArray2, dArray3, n);
        }
        return new TwoTensorFitter(dArray, dArray2, dArray3, n);
    }
}

