/*
 * Decompiled with CFR 0.152.
 */
package misc;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import java.util.logging.Logger;
import misc.LoggedException;
import numerics.RealMatrix;

public class DT
implements Cloneable {
    private static Logger logger = Logger.getLogger("camino.misc.DT");
    protected final double dxx;
    protected final double dxy;
    protected final double dxz;
    protected final double dyy;
    protected final double dyz;
    protected final double dzz;

    public DT(double d, double d2, double d3, double d4, double d5, double d6) {
        this.dxx = d;
        this.dxy = d2;
        this.dxz = d3;
        this.dyy = d4;
        this.dyz = d5;
        this.dzz = d6;
    }

    public DT(double[] dArray) {
        this.dxx = dArray[0];
        this.dxy = dArray[1];
        this.dxz = dArray[2];
        this.dyy = dArray[3];
        this.dyz = dArray[4];
        this.dzz = dArray[5];
    }

    public double contractBy(double[] dArray) {
        return dArray[0] * (this.dxx * dArray[0] + this.dxy * dArray[1] + this.dxz * dArray[2]) + dArray[1] * (this.dxy * dArray[0] + this.dyy * dArray[1] + this.dyz * dArray[2]) + dArray[2] * (this.dxz * dArray[0] + this.dyz * dArray[1] + this.dzz * dArray[2]);
    }

    public RealMatrix toMatrix() {
        RealMatrix realMatrix = new RealMatrix(3, 3);
        realMatrix.entries[0][0] = this.dxx;
        realMatrix.entries[0][1] = this.dxy;
        realMatrix.entries[0][2] = this.dxz;
        realMatrix.entries[1][1] = this.dyy;
        realMatrix.entries[1][2] = this.dyz;
        realMatrix.entries[2][2] = this.dzz;
        realMatrix.entries[1][0] = this.dxy;
        realMatrix.entries[2][0] = this.dxz;
        realMatrix.entries[2][1] = this.dyz;
        return realMatrix;
    }

    public double[] multiply(double[] dArray) {
        double[] dArray2 = new double[]{this.dxx * dArray[0] + this.dxy * dArray[1] + this.dxz * dArray[2], this.dxy * dArray[0] + this.dyy * dArray[1] + this.dyz * dArray[2], this.dxz * dArray[0] + this.dyz * dArray[1] + this.dzz * dArray[2]};
        return dArray2;
    }

    public Object clone() {
        return new DT(this.dxx, this.dxy, this.dxz, this.dyy, this.dyz, this.dzz);
    }

    public double determinant() {
        return -this.dxz * this.dxz * this.dyy + this.dxy * this.dxz * this.dyz + this.dxy * this.dxz * this.dyz - this.dxx * this.dyz * this.dyz - this.dxy * this.dxy * this.dzz + this.dxx * this.dyy * this.dzz;
    }

    public double trace() {
        return this.dxx + this.dyy + this.dzz;
    }

    public double fa() {
        double d = this.trace() / 3.0;
        d *= d;
        double d2 = this.dxx * this.dxx + 2.0 * this.dxy * this.dxy + 2.0 * this.dxz * this.dxz + this.dyy * this.dyy + 2.0 * this.dyz * this.dyz + this.dzz * this.dzz;
        double d3 = 0.0;
        if (d2 != 0.0) {
            double d4 = 3.0 * (1.0 - 3.0 * d / d2) / 2.0;
            if (d4 >= 0.0) {
                d3 = Math.sqrt(d4);
            } else if (d4 > -1.0E-9) {
                d3 = 0.0;
            } else {
                logger.warning("Spurious FA value : " + d3 + " for tensor\n" + this.toString());
            }
        }
        return d3;
    }

    public DT iTransform(RealMatrix realMatrix) {
        double d = realMatrix.entry(0, 0);
        double d2 = realMatrix.entry(0, 1);
        double d3 = realMatrix.entry(0, 2);
        double d4 = realMatrix.entry(1, 0);
        double d5 = realMatrix.entry(1, 1);
        double d6 = realMatrix.entry(1, 2);
        double d7 = realMatrix.entry(2, 0);
        double d8 = realMatrix.entry(2, 1);
        double d9 = realMatrix.entry(2, 2);
        return this.doTrans(d, d2, d3, d4, d5, d6, d7, d8, d9);
    }

    protected DT doTrans(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        double d10 = d * d * this.dxx + 2.0 * d * d4 * this.dxy + d4 * d4 * this.dyy + d * this.dxz * d7 + d * this.dxz * d7 + 2.0 * d4 * this.dyz * d7 + this.dzz * d7 * d7;
        double d11 = d * d2 * this.dxx + d2 * d4 * this.dxy + d * this.dxy * d5 + d4 * this.dyy * d5 + d2 * this.dxz * d7 + this.dyz * d5 * d7 + d * this.dxz * d8 + d4 * this.dyz * d8 + this.dzz * d7 * d8;
        double d12 = d * d3 * this.dxx + d3 * d4 * this.dxy + d * this.dxy * d6 + d4 * this.dyy * d6 + d3 * this.dxz * d7 + this.dyz * d6 * d7 + d * this.dxz * d9 + d4 * this.dyz * d9 + this.dzz * d7 * d9;
        double d13 = d2 * d2 * this.dxx + 2.0 * d2 * this.dxy * d5 + this.dyy * d5 * d5 + d2 * this.dxz * d8 + d2 * this.dxz * d8 + 2.0 * this.dyz * d5 * d8 + this.dzz * d8 * d8;
        double d14 = d2 * d3 * this.dxx + d3 * this.dxy * d5 + d2 * this.dxy * d6 + this.dyy * d5 * d6 + d3 * this.dxz * d8 + this.dyz * d6 * d8 + d2 * this.dxz * d9 + this.dyz * d5 * d9 + this.dzz * d8 * d9;
        double d15 = d3 * d3 * this.dxx + 2.0 * d3 * this.dxy * d6 + this.dyy * d6 * d6 + d3 * this.dxz * d9 + d3 * this.dxz * d9 + 2.0 * this.dyz * d6 * d9 + this.dzz * d9 * d9;
        return new DT(d10, d11, d12, d13, d14, d15);
    }

    public DT transform(RealMatrix realMatrix) {
        double d = realMatrix.entry(0, 0);
        double d2 = realMatrix.entry(0, 1);
        double d3 = realMatrix.entry(0, 2);
        double d4 = realMatrix.entry(1, 0);
        double d5 = realMatrix.entry(1, 1);
        double d6 = realMatrix.entry(1, 2);
        double d7 = realMatrix.entry(2, 0);
        double d8 = realMatrix.entry(2, 1);
        double d9 = realMatrix.entry(2, 2);
        return this.doTrans(d, d4, d7, d2, d5, d8, d3, d6, d9);
    }

    public DT inverse() {
        double d = this.determinant();
        double d2 = (-this.dyz * this.dyz + this.dyy * this.dzz) / d;
        double d3 = (this.dxz * this.dyz - this.dxy * this.dzz) / d;
        double d4 = (-this.dxz * this.dyy + this.dxy * this.dyz) / d;
        double d5 = (-this.dxz * this.dxz + this.dxx * this.dzz) / d;
        double d6 = (this.dxy * this.dxz - this.dxx * this.dyz) / d;
        double d7 = (-this.dxy * this.dxy + this.dxx * this.dyy) / d;
        return new DT(d2, d3, d4, d5, d6, d7);
    }

    public DT scale(double d) {
        return new DT(d * this.dxx, d * this.dxy, d * this.dxz, d * this.dyy, d * this.dyz, d * this.dzz);
    }

    public double[] getComponents() {
        double[] dArray = new double[]{this.dxx, this.dxy, this.dxz, this.dyy, this.dyz, this.dzz};
        return dArray;
    }

    public double[][] eigenSystem() {
        Matrix matrix = new Matrix(3, 3);
        matrix.set(0, 0, this.dxx);
        matrix.set(0, 1, this.dxy);
        matrix.set(1, 0, this.dxy);
        matrix.set(1, 1, this.dyy);
        matrix.set(0, 2, this.dxz);
        matrix.set(2, 0, this.dxz);
        matrix.set(2, 2, this.dzz);
        matrix.set(1, 2, this.dyz);
        matrix.set(2, 1, this.dyz);
        try {
            EigenvalueDecomposition eigenvalueDecomposition = new EigenvalueDecomposition(matrix);
            double[] dArray = eigenvalueDecomposition.getRealEigenvalues();
            Matrix matrix2 = eigenvalueDecomposition.getV();
            double[][] dArray2 = new double[4][3];
            double[][] dArray3 = matrix2.getArray();
            for (int i = 0; i < 3; ++i) {
                dArray2[0][i] = dArray[i];
                for (int j = 0; j < 3; ++j) {
                    dArray2[j + 1][i] = dArray3[j][i];
                }
            }
            return dArray2;
        }
        catch (Exception exception) {
            LoggedException.logExceptionWarning(exception, "Bad tensor data, returning default values, program will continue.\n Tensor was :\n" + this.toString(), Thread.currentThread().getName());
            double[][] dArray = new double[4][3];
            dArray[1][0] = 1.0;
            dArray[1][1] = 1.0;
            dArray[1][2] = 1.0;
            return dArray;
        }
    }

    public double[][] sortedEigenSystem() {
        int n;
        double[][] dArray = this.eigenSystem();
        int n2 = 0;
        int n3 = 0;
        for (n = 1; n < 3; ++n) {
            if (dArray[0][n] >= dArray[0][n3]) {
                n3 = n;
            }
            if (!(dArray[0][n] < dArray[0][n2])) continue;
            n2 = n;
        }
        n = 3 - n2 - n3;
        double[][] dArray2 = new double[4][3];
        for (int i = 0; i < 4; ++i) {
            dArray2[i][0] = dArray[i][n3];
            dArray2[i][1] = dArray[i][n];
            dArray2[i][2] = dArray[i][n2];
        }
        return dArray2;
    }

    public DT ppd(RealMatrix realMatrix) {
        double[][] dArray = this.sortedEigenSystem();
        RealMatrix realMatrix2 = new RealMatrix(3, 3);
        RealMatrix realMatrix3 = new RealMatrix(3, 1);
        RealMatrix realMatrix4 = new RealMatrix(3, 1);
        for (int i = 0; i < 3; ++i) {
            realMatrix2.entries[i][i] = dArray[0][i];
            realMatrix3.entries[i][0] = dArray[i + 1][0];
            realMatrix4.entries[i][0] = dArray[i + 1][1];
        }
        RealMatrix realMatrix5 = realMatrix.product(realMatrix3);
        RealMatrix realMatrix6 = realMatrix.product(realMatrix4);
        double d = Math.sqrt(realMatrix5.entries[0][0] * realMatrix5.entries[0][0] + realMatrix5.entries[1][0] * realMatrix5.entries[1][0] + realMatrix5.entries[2][0] * realMatrix5.entries[2][0]);
        double d2 = Math.sqrt(realMatrix6.entries[0][0] * realMatrix6.entries[0][0] + realMatrix6.entries[1][0] * realMatrix6.entries[1][0] + realMatrix6.entries[2][0] * realMatrix6.entries[2][0]);
        for (int i = 0; i < 3; ++i) {
            realMatrix5.entries[i][0] = realMatrix5.entries[i][0] / d;
            realMatrix6.entries[i][0] = realMatrix6.entries[i][0] / d2;
        }
        RealMatrix realMatrix7 = new RealMatrix(3, 3);
        for (int i = 0; i < 3; ++i) {
            realMatrix7.entries[i][0] = realMatrix5.entries[i][0];
        }
        double d3 = realMatrix5.entries[0][0] * realMatrix6.entries[0][0] + realMatrix5.entries[1][0] * realMatrix6.entries[1][0] + realMatrix5.entries[2][0] * realMatrix6.entries[2][0];
        RealMatrix realMatrix8 = realMatrix6.add(realMatrix5.scalarMult(-d3));
        double d4 = Math.sqrt(realMatrix8.entries[0][0] * realMatrix8.entries[0][0] + realMatrix8.entries[1][0] * realMatrix8.entries[1][0] + realMatrix8.entries[2][0] * realMatrix8.entries[2][0]);
        for (int i = 0; i < 3; ++i) {
            realMatrix7.entries[i][1] = realMatrix8.entries[i][0] / d4;
        }
        realMatrix7.entries[0][2] = realMatrix7.entries[1][0] * realMatrix7.entries[2][1] - realMatrix7.entries[1][1] * realMatrix7.entries[2][0];
        realMatrix7.entries[1][2] = realMatrix7.entries[2][0] * realMatrix7.entries[0][1] - realMatrix7.entries[2][1] * realMatrix7.entries[0][0];
        realMatrix7.entries[2][2] = realMatrix7.entries[0][0] * realMatrix7.entries[1][1] - realMatrix7.entries[0][1] * realMatrix7.entries[1][0];
        RealMatrix realMatrix9 = realMatrix7.product(realMatrix2.product(realMatrix7.transpose()));
        return new DT(realMatrix9.entries[0][0], realMatrix9.entries[0][1], realMatrix9.entries[0][2], realMatrix9.entries[1][1], realMatrix9.entries[1][2], realMatrix9.entries[2][2]);
    }

    public double[] getPD() {
        double[][] dArray = this.sortedEigenSystem();
        double[] dArray2 = new double[]{dArray[1][0], dArray[2][0], dArray[3][0]};
        return dArray2;
    }

    public double[] eigenValues() {
        double[][] dArray = this.eigenSystem();
        double[] dArray2 = new double[3];
        for (int i = 0; i < 3; ++i) {
            dArray2[i] = dArray[0][i];
        }
        return dArray2;
    }

    public static DT dtFromEig(double[][] dArray) {
        RealMatrix realMatrix = new RealMatrix(new double[][]{{dArray[1][0]}, {dArray[2][0]}, {dArray[3][0]}});
        RealMatrix realMatrix2 = new RealMatrix(new double[][]{{dArray[1][1]}, {dArray[2][1]}, {dArray[3][1]}});
        RealMatrix realMatrix3 = new RealMatrix(new double[][]{{dArray[1][2]}, {dArray[2][2]}, {dArray[3][2]}});
        RealMatrix realMatrix4 = realMatrix.product(realMatrix.transpose()).scalarMult(dArray[0][0]);
        RealMatrix realMatrix5 = realMatrix2.product(realMatrix2.transpose()).scalarMult(dArray[0][1]);
        RealMatrix realMatrix6 = realMatrix3.product(realMatrix3.transpose()).scalarMult(dArray[0][2]);
        RealMatrix realMatrix7 = realMatrix4.add(realMatrix5).add(realMatrix6);
        return new DT(realMatrix7.entries[0][0], realMatrix7.entries[0][1], realMatrix7.entries[0][2], realMatrix7.entries[1][1], realMatrix7.entries[1][2], realMatrix7.entries[2][2]);
    }

    public String toString() {
        String string = this.dxx + " " + this.dxy + " " + this.dxz + "\n";
        string = string + this.dxy + " " + this.dyy + " " + this.dyz + "\n";
        string = string + this.dxz + " " + this.dyz + " " + this.dzz + "\n";
        return string;
    }
}

