/*
 * Decompiled with CFR 0.152.
 */
package misc;

import misc.VoxelwiseStatisticalImage;
import numerics.Point3D;
import tools.ArrayOps;

public class SparseVectorImage
implements VoxelwiseStatisticalImage {
    private final double[][][][] data;
    private final double[][][][] weights;
    private final int[] dataDims;
    private final double[] voxelDims;
    private final int[][][] vectorLengths;
    protected static final int INITIAL_ARRAY_LENGTH = 50;
    private static final double GROWTH_FACTOR = 2.0;

    public SparseVectorImage(int[] nArray, double[] dArray) {
        this.voxelDims = dArray;
        this.dataDims = nArray;
        this.data = new double[nArray[0]][nArray[1]][nArray[2]][];
        this.weights = new double[nArray[0]][nArray[1]][nArray[2]][];
        this.vectorLengths = new int[nArray[0]][nArray[1]][nArray[2]];
    }

    @Override
    public void addValue(int n, int n2, int n3, double d) {
        this.addValue(n, n2, n3, d, 1.0);
    }

    @Override
    public void addValue(int n, int n2, int n3, double d, double d2) {
        if (this.data[n][n2][n3] == null) {
            this.data[n][n2][n3] = new double[50];
            this.weights[n][n2][n3] = new double[50];
        }
        this.data[n][n2][n3][this.vectorLengths[n][n2][n3]] = d;
        this.weights[n][n2][n3][this.vectorLengths[n][n2][n3]] = d2;
        int[] nArray = this.vectorLengths[n][n2];
        int n4 = n3;
        nArray[n4] = nArray[n4] + 1;
        if (this.vectorLengths[n][n2][n3] == this.data[n][n2][n3].length) {
            this.growDataVectors(n, n2, n3, 2.0);
        }
    }

    @Override
    public void addValue(Point3D point3D, double d) {
        this.addValue(point3D, d, 1.0);
    }

    @Override
    public void addValue(Point3D point3D, double d, double d2) {
        int n = (int)(point3D.x / this.voxelDims[0]);
        int n2 = (int)(point3D.y / this.voxelDims[1]);
        int n3 = (int)(point3D.z / this.voxelDims[2]);
        this.addValue(n, n2, n3, d, d2);
    }

    @Override
    public double[][][] getVoxelStatistic(String string) {
        double[][][] dArray = new double[this.dataDims[0]][this.dataDims[1]][this.dataDims[2]];
        for (int i = 0; i < this.dataDims[0]; ++i) {
            for (int j = 0; j < this.dataDims[1]; ++j) {
                for (int k = 0; k < this.dataDims[2]; ++k) {
                    if (this.vectorLengths[i][j][k] <= 0) continue;
                    if (string.equals("mean")) {
                        dArray[i][j][k] = ArrayOps.weightedMean(this.valuesAt(this.data, i, j, k), this.valuesAt(this.weights, i, j, k));
                        continue;
                    }
                    if (string.equals("max")) {
                        dArray[i][j][k] = ArrayOps.max(this.valuesAt(this.data, i, j, k));
                        continue;
                    }
                    if (string.equals("min")) {
                        dArray[i][j][k] = ArrayOps.min(this.valuesAt(this.data, i, j, k));
                        continue;
                    }
                    if (string.equals("median")) {
                        dArray[i][j][k] = ArrayOps.median(this.valuesAt(this.data, i, j, k));
                        continue;
                    }
                    if (!string.equals("var")) continue;
                    double[] dArray2 = this.valuesAt(this.data, i, j, k);
                    double[] dArray3 = this.valuesAt(this.weights, i, j, k);
                    dArray[i][j][k] = ArrayOps.weightedVar(dArray2, dArray3, ArrayOps.weightedMean(dArray2, dArray3));
                }
            }
        }
        return dArray;
    }

    private double[] valuesAt(double[][][][] dArray, int n, int n2, int n3) {
        if (this.vectorLengths[n][n2][n3] == 0) {
            return new double[0];
        }
        double[] dArray2 = new double[this.vectorLengths[n][n2][n3]];
        System.arraycopy(dArray[n][n2][n3], 0, dArray2, 0, dArray2.length);
        return dArray2;
    }

    private void growDataVectors(int n, int n2, int n3, double d) {
        int n4 = this.data[n][n2][n3].length;
        int n5 = (int)((double)n4 * d);
        double[] dArray = new double[n5];
        System.arraycopy(this.data[n][n2][n3], 0, dArray, 0, n4);
        this.data[n][n2][n3] = dArray;
        dArray = new double[n5];
        System.arraycopy(this.weights[n][n2][n3], 0, dArray, 0, n4);
        this.weights[n][n2][n3] = dArray;
    }
}

