/*
 * Decompiled with CFR 0.152.
 */
package models.compartments;

import imaging.DW_Scheme;
import imaging.StejskalTannerScheme;
import java.util.logging.Logger;
import misc.LoggedException;
import models.ParametricModel;
import models.compartments.CompartmentType;
import numerics.ErrorFunction;
import numerics.ErrorFunctionException;
import numerics.RealMatrix;

public class Astrocylinders
extends ParametricModel {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final double GAMMA = 2.6751525E8;
    private final double[] am = new double[]{1.8411830786136, 5.33144196877749, 8.53631578218074, 11.7060038949077, 14.8635881488839, 18.0155278304879, 21.1643671187891, 24.3113254834588, 27.4570501848623, 30.6019229722078, 33.7461812269726, 36.8899866873805, 40.033443940961, 43.1766274212415, 46.3195966792621, 49.4623908440429, 52.6050411092602, 55.7475709551533, 58.8900018651876, 62.0323477967829, 65.1746202084584, 68.3168306640438, 71.4589869258787, 74.6010956133729, 77.7431620631416, 80.885192105728, 84.0271895462953, 87.1691575709855, 90.3110993488875, 93.4530179063458, 96.5949155953313, 99.736793220382, 102.878653768715, 106.020498619541, 109.162329055405, 112.304145672561, 115.445950418834, 118.587744574512, 121.729527118091, 124.871300497614, 128.013065217171, 131.15482196525, 134.296570328107, 137.438311926144, 140.580047659913, 143.721775748727, 146.863498476739, 150.005215971725, 153.146928691331, 156.288635801966, 159.430338769213, 162.572038308643, 165.713732347338, 168.855423073845, 171.997111729391, 175.138794734935, 178.280475036977, 181.422152668422, 184.563828222242, 187.705499575101};

    public Astrocylinders() {
        super(CompartmentType.ASTROCYLINDERS.numParams);
    }

    @Override
    public RealMatrix getSignals(double[] dArray, DW_Scheme dW_Scheme) {
        StejskalTannerScheme stejskalTannerScheme;
        RealMatrix realMatrix = new RealMatrix(dW_Scheme.numMeasurements(), 1);
        try {
            stejskalTannerScheme = (StejskalTannerScheme)dW_Scheme;
        }
        catch (ClassCastException classCastException) {
            throw new LoggedException("scheme object passed to astrocylinder compartment is not a StejskalTanner sequence");
        }
        for (int i = 0; i < stejskalTannerScheme.numMeasurements(); ++i) {
            realMatrix.setEntry(i, 0, this.getSignal(dArray, stejskalTannerScheme, i));
        }
        return realMatrix;
    }

    @Override
    public double getSignal(double[] dArray, DW_Scheme dW_Scheme, int n) {
        StejskalTannerScheme stejskalTannerScheme;
        try {
            stejskalTannerScheme = (StejskalTannerScheme)dW_Scheme;
        }
        catch (ClassCastException classCastException) {
            throw new LoggedException("scheme object passed to cylinder compartment is not a StejskalTanner sequence");
        }
        return this.getSignal(dArray, stejskalTannerScheme, n);
    }

    private double getSignal(double[] dArray, StejskalTannerScheme stejskalTannerScheme, int n) {
        double d;
        if (stejskalTannerScheme.zero(n)) {
            return 1.0;
        }
        double d2 = dArray[1];
        double d3 = stejskalTannerScheme.getB_Value(n);
        double d4 = stejskalTannerScheme.getDELTA(n);
        double d5 = stejskalTannerScheme.getDelta(n);
        double d6 = stejskalTannerScheme.getModG(n);
        double[] dArray2 = stejskalTannerScheme.getG_Dir(n);
        double[] dArray3 = new double[3];
        for (int i = 0; i < dArray3.length; ++i) {
            dArray3[i] = dArray2[i] * d6;
        }
        double[] dArray4 = new double[this.am.length];
        for (int i = 0; i < this.am.length; ++i) {
            dArray4[i] = this.am[i] / d2;
        }
        double d7 = 0.0;
        for (int i = 0; i < dArray4.length; ++i) {
            double d8 = dArray[0] * dArray4[i] * dArray4[i];
            double d9 = -d8 * d5;
            double d10 = -d8 * d4;
            double d11 = d4 - d5;
            double d12 = -d8 * d11;
            double d13 = d4 + d5;
            double d14 = -d8 * d13;
            double d15 = 2.0 * d8 * d5 - 2.0 + 2.0 * Math.exp(d9) + 2.0 * Math.exp(d10) - Math.exp(d12) - Math.exp(d14);
            double d16 = d8 * d8 * dArray4[i] * dArray4[i] * (d2 * d2 * dArray4[i] * dArray4[i] - 1.0);
            d7 += d15 / d16;
        }
        double d17 = -1.43128817965125E17 * d7;
        double d18 = -d3 * 1.0 / (d6 * d6) * dArray[0];
        try {
            d = Math.sqrt(Math.PI) * 1.0 / (2.0 * d6 * Math.sqrt(d17 - d18)) * Math.exp(d6 * d6 * d17) * ErrorFunction.erf(d6 * Math.sqrt(d17 - d18));
        }
        catch (ErrorFunctionException errorFunctionException) {
            throw new LoggedException(errorFunctionException);
        }
        return d;
    }
}

