/*
 * Decompiled with CFR 0.152.
 */
package models.compartments;

import imaging.DW_Scheme;
import models.ParametricModel;
import models.compartments.CompartmentType;
import numerics.RealMatrix;

public class Ball
extends ParametricModel {
    public Ball() {
        super(CompartmentType.BALL.numParams);
    }

    @Override
    public RealMatrix getSignals(double[] dArray, DW_Scheme dW_Scheme) {
        RealMatrix realMatrix = new RealMatrix(dW_Scheme.numMeasurements(), 1);
        for (int i = 0; i < dW_Scheme.numMeasurements(); ++i) {
            realMatrix.setEntry(i, 0, this.getSignal(dArray, dW_Scheme, i));
        }
        return realMatrix;
    }

    @Override
    public double getSignal(double[] dArray, DW_Scheme dW_Scheme, int n) {
        double d = dW_Scheme.getB_Value(n);
        return Math.exp(-d * dArray[0]);
    }

    @Override
    public RealMatrix getJacobian(double[] dArray, DW_Scheme dW_Scheme) {
        RealMatrix realMatrix = new RealMatrix(dW_Scheme.numMeasurements(), 1);
        RealMatrix realMatrix2 = this.getSignals(dArray, dW_Scheme);
        for (int i = 0; i < dW_Scheme.numMeasurements(); ++i) {
            double d = dW_Scheme.getB_Value(i);
            realMatrix.setEntry(i, 0, -d * realMatrix2.entries[i][0]);
        }
        return realMatrix;
    }
}

