/*
 * Decompiled with CFR 0.152.
 */
package models.compartments;

import misc.LoggedException;
import models.ParametricModel;
import models.compartments.Astrocylinders;
import models.compartments.Astrosticks;
import models.compartments.Ball;
import models.compartments.CylinderGPD;
import models.compartments.Dot;
import models.compartments.GDRCylinders;
import models.compartments.SphereGPD;
import models.compartments.Stick;
import models.compartments.Tensor;
import models.compartments.Zeppelin;

public class CompartmentFactory {
    public static ParametricModel getCompartment(String string) {
        if (string.equalsIgnoreCase("ball")) {
            return new Ball();
        }
        if (string.equalsIgnoreCase("stick")) {
            return new Stick();
        }
        if (string.equalsIgnoreCase("zeppelin")) {
            return new Zeppelin();
        }
        if (string.equalsIgnoreCase("tensor")) {
            return new Tensor();
        }
        if (string.equalsIgnoreCase("cylinderGPD")) {
            return new CylinderGPD();
        }
        if (string.equalsIgnoreCase("sphereGPD")) {
            return new SphereGPD();
        }
        if (string.equalsIgnoreCase("dot")) {
            return new Dot();
        }
        if (string.equalsIgnoreCase("astrosticks")) {
            return new Astrosticks();
        }
        if (string.equalsIgnoreCase("astrocylinders")) {
            return new Astrocylinders();
        }
        if (string.equalsIgnoreCase("gammadistribradiicylinders")) {
            return new GDRCylinders();
        }
        throw new LoggedException("unrecognised compartment type name '" + string + "'");
    }
}

