/*
 * Decompiled with CFR 0.152.
 */
package models.compartments;

import data.DataSource;
import data.DataSourceException;
import imaging.DW_Scheme;
import java.util.logging.Logger;
import models.ParametricModel;
import models.compartments.CompartmentFactory;
import models.compartments.CompartmentType;
import numerics.RealMatrix;
import tools.CL_Initializer;

public class CompartmentModel
extends ParametricModel
implements DataSource {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private DW_Scheme scheme = null;
    private final ParametricModel[] compartment;
    private final String[] compartmentnames;
    private final double[][] compParams;
    private final double[] linParams;
    private final int[][] index;
    private int voxel = 0;
    private final int START = 0;
    private final int END = 1;

    public CompartmentModel(String[] stringArray, double[] dArray) {
        super(CompartmentModel.getNumParamsFor(stringArray));
        int n;
        this.compartment = new ParametricModel[stringArray.length];
        this.compParams = new double[stringArray.length][];
        this.compartmentnames = stringArray;
        this.linParams = dArray;
        for (n = 0; n < stringArray.length; ++n) {
            this.compartment[n] = CompartmentFactory.getCompartment(stringArray[n]);
        }
        n = this.compartment.length;
        this.index = new int[n][2];
        int n2 = n + 1;
        for (int i = 0; i < n; ++i) {
            CompartmentType compartmentType = CompartmentType.getCompartmentType(stringArray[i]);
            this.index[i][0] = n2;
            this.index[i][1] = n2 += compartmentType.numParams;
            this.compParams[i] = new double[compartmentType.numParams];
        }
    }

    public CompartmentModel(String[] stringArray, double[] dArray, DW_Scheme dW_Scheme) {
        this(stringArray, dArray);
        this.scheme = dW_Scheme;
    }

    private static int getNumParamsFor(String[] stringArray) {
        int n = stringArray.length + 1;
        for (int i = 0; i < stringArray.length; ++i) {
            n += CompartmentType.getCompartmentType((String)stringArray[i]).numParams;
        }
        return n;
    }

    @Override
    public RealMatrix getSignals(double[] dArray, DW_Scheme dW_Scheme) {
        int n;
        RealMatrix realMatrix = new RealMatrix(dW_Scheme.numMeasurements(), 1);
        double[] dArray2 = new double[this.compartment.length];
        double d = 0.0;
        for (n = 0; n < this.compartment.length - 1; ++n) {
            d += dArray[n + 1];
            dArray2[n] = dArray[n + 1];
        }
        dArray2[this.compartment.length - 1] = 1.0 - d;
        if (dArray2[this.compartment.length - 1] < 0.0 || dArray2[this.compartment.length - 1] > 1.0) {
            // empty if block
        }
        for (n = 0; n < this.compartment.length; ++n) {
            double[] dArray3 = new double[this.compartment[n].numParams()];
            for (int i = this.index[n][0]; i < this.index[n][1]; ++i) {
                dArray3[i - this.index[n][0]] = dArray[i];
            }
            RealMatrix realMatrix2 = this.compartment[n].getSignals(dArray3, dW_Scheme);
            realMatrix2 = realMatrix2.scalarMult(dArray2[n]);
            realMatrix = realMatrix.add(realMatrix2);
        }
        realMatrix = realMatrix.scalarMult(dArray[0]);
        return realMatrix;
    }

    @Override
    public double getSignal(double[] dArray, DW_Scheme dW_Scheme, int n) {
        int n2;
        double d = 0.0;
        double[] dArray2 = new double[this.compartment.length];
        double d2 = 0.0;
        for (n2 = 0; n2 < this.compartment.length - 1; ++n2) {
            d2 += dArray[n2 + 1];
            dArray2[n2] = dArray[n2 + 1];
        }
        dArray2[this.compartment.length - 1] = 1.0 - d2;
        if (dArray2[this.compartment.length - 1] < 0.0 || dArray2[this.compartment.length - 1] > 1.0) {
            // empty if block
        }
        for (n2 = 0; n2 < this.compartment.length; ++n2) {
            for (int i = this.index[n2][0]; i < this.index[n2][1]; ++i) {
                this.compParams[n2][i - this.index[n2][0]] = dArray[i];
            }
            double d3 = this.compartment[n2].getSignal(this.compParams[n2], dW_Scheme, n);
            d += (d3 *= dArray2[n2]);
        }
        return dArray[0] * d;
    }

    @Override
    public RealMatrix getJacobian(double[] dArray, DW_Scheme dW_Scheme) {
        int n;
        int n2;
        int n3;
        RealMatrix realMatrix = new RealMatrix(dW_Scheme.numMeasurements(), dArray.length);
        double d = dArray[0];
        RealMatrix realMatrix2 = this.getSignals(dArray, dW_Scheme);
        for (int i = 0; i < dW_Scheme.numMeasurements(); ++i) {
            realMatrix.setEntry(i, 0, realMatrix2.entry(i, 0) / d);
        }
        double[] dArray2 = new double[this.compartment.length];
        double d2 = 0.0;
        for (n3 = 0; n3 < this.compartment.length; ++n3) {
            d2 += dArray[n3 + 1];
        }
        for (n3 = 0; n3 < this.compartment.length; ++n3) {
            dArray2[n3] = dArray[n3 + 1] / d2;
        }
        for (n3 = 0; n3 < this.compartment.length; ++n3) {
            for (n2 = this.index[n3][0]; n2 < this.index[n3][1]; ++n2) {
                this.compParams[n3][n2 - this.index[n3][0]] = dArray[n2];
            }
        }
        RealMatrix realMatrix3 = this.compartment[this.compartment.length - 1].getJacobian(this.compParams[this.compartment.length - 1], dW_Scheme);
        for (n2 = this.index[this.compartment.length - 1][0]; n2 < this.index[this.compartment.length - 1][1]; ++n2) {
            n = n2 - this.index[this.compartment.length - 1][0];
            int n4 = n2;
            for (int i = 0; i < dW_Scheme.numMeasurements(); ++i) {
                realMatrix.setEntry(i, n4, d * dArray2[this.compartment.length - 1] * realMatrix3.entry(i, n));
            }
        }
        RealMatrix realMatrix4 = this.compartment[this.compartment.length - 1].getSignals(this.compParams[this.compartment.length - 1], dW_Scheme);
        for (n = 0; n < this.compartment.length - 1; ++n) {
            int n5;
            double d3 = dArray2[n];
            RealMatrix realMatrix5 = this.compartment[n].getJacobian(this.compParams[n], dW_Scheme);
            for (int i = this.index[n][0]; i < this.index[n][1]; ++i) {
                n5 = i - this.index[n][0];
                int n6 = i;
                for (int j = 0; j < dW_Scheme.numMeasurements(); ++j) {
                    realMatrix.setEntry(j, n6, d * d3 * realMatrix5.entry(j, n5));
                }
            }
            RealMatrix realMatrix6 = this.compartment[n].getSignals(this.compParams[n], dW_Scheme);
            for (n5 = 0; n5 < dW_Scheme.numMeasurements(); ++n5) {
                realMatrix.setEntry(n5, n + 1, d * (realMatrix6.entry(n5, 0) - realMatrix4.entry(n5, 0)));
            }
        }
        return realMatrix;
    }

    @Override
    public boolean more() {
        return this.voxel < CL_Initializer.numVoxels;
    }

    @Override
    public double[] nextVoxel() throws DataSourceException {
        RealMatrix realMatrix = this.getSignals(this.linParams, this.scheme);
        double[] dArray = new double[this.scheme.numMeasurements()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = realMatrix.entry(i, 0);
        }
        ++this.voxel;
        return dArray;
    }

    public String[] getCompartmentnames() {
        return this.compartmentnames;
    }
}

