/*
 * Decompiled with CFR 0.152.
 */
package models.compartments;

import imaging.DW_Scheme;
import imaging.StejskalTannerScheme;
import java.util.logging.Logger;
import misc.LoggedException;
import models.ParametricModel;
import models.compartments.CompartmentType;
import numerics.RealMatrix;

public class CylinderGPD
extends ParametricModel {
    protected static Logger logger = Logger.getLogger("camino.models.compartments.CylinderGPD");
    private final double GAMMA = 2.6751525E8;
    private double REQPREC = 1.0E-7;
    private double lastDelta = 0.0;
    private double lastDELTA = 0.0;
    private double lastDiff = 0.0;
    private double lastR = 0.0;
    private double lastSum = 0.0;
    private final double[] am = new double[]{1.8411830786136, 5.33144196877749, 8.53631578218074, 11.7060038949077, 14.8635881488839, 18.0155278304879, 21.1643671187891, 24.3113254834588, 27.4570501848623, 30.6019229722078, 33.7461812269726, 36.8899866873805, 40.033443940961, 43.1766274212415, 46.3195966792621, 49.4623908440429, 52.6050411092602, 55.7475709551533, 58.8900018651876, 62.0323477967829, 65.1746202084584, 68.3168306640438, 71.4589869258787, 74.6010956133729, 77.7431620631416, 80.885192105728, 84.0271895462953, 87.1691575709855, 90.3110993488875, 93.4530179063458, 96.5949155953313, 99.736793220382, 102.878653768715, 106.020498619541, 109.162329055405, 112.304145672561, 115.445950418834, 118.587744574512, 121.729527118091, 124.871300497614, 128.013065217171, 131.15482196525, 134.296570328107, 137.438311926144, 140.580047659913, 143.721775748727, 146.863498476739, 150.005215971725, 153.146928691331, 156.288635801966, 159.430338769213, 162.572038308643, 165.713732347338, 168.855423073845, 171.997111729391, 175.138794734935, 178.280475036977, 181.422152668422, 184.563828222242, 187.705499575101};

    public CylinderGPD() {
        super(CompartmentType.CYLINDERGPD.numParams);
    }

    @Override
    public RealMatrix getSignals(double[] dArray, DW_Scheme dW_Scheme) {
        StejskalTannerScheme stejskalTannerScheme;
        RealMatrix realMatrix = new RealMatrix(dW_Scheme.numMeasurements(), 1);
        try {
            stejskalTannerScheme = (StejskalTannerScheme)dW_Scheme;
        }
        catch (ClassCastException classCastException) {
            throw new LoggedException("scheme object passed to cylinder compartment is not a StejskalTanner sequence");
        }
        for (int i = 0; i < stejskalTannerScheme.numMeasurements(); ++i) {
            realMatrix.setEntry(i, 0, this.getSignal(dArray, stejskalTannerScheme, i));
        }
        return realMatrix;
    }

    @Override
    public double getSignal(double[] dArray, DW_Scheme dW_Scheme, int n) {
        StejskalTannerScheme stejskalTannerScheme;
        try {
            stejskalTannerScheme = (StejskalTannerScheme)dW_Scheme;
        }
        catch (ClassCastException classCastException) {
            throw new LoggedException("scheme object passed to cylinder compartment is not a StejskalTanner sequence");
        }
        return this.getSignal(dArray, stejskalTannerScheme, n);
    }

    private double getSignal(double[] dArray, StejskalTannerScheme stejskalTannerScheme, int n) {
        if (stejskalTannerScheme.zero(n)) {
            return 1.0;
        }
        double d = stejskalTannerScheme.getDELTA(n);
        double d2 = stejskalTannerScheme.getDelta(n);
        double d3 = stejskalTannerScheme.getModG(n);
        double[] dArray2 = stejskalTannerScheme.getG_Dir(n);
        double[] dArray3 = new double[3];
        for (int i = 0; i < dArray3.length; ++i) {
            dArray3[i] = dArray2[i] * d3;
        }
        return this.getSignal(dArray, d2, d, dArray3);
    }

    public double getSignal(double[] dArray, double d, double d2, double[] dArray2) {
        double d3 = dArray[0];
        double d4 = dArray[1];
        double d5 = dArray[2];
        double d6 = dArray[3];
        double d7 = d2 - d / 3.0;
        double d8 = 0.0;
        for (int i = 0; i < dArray2.length; ++i) {
            d8 += dArray2[i] * dArray2[i];
        }
        d8 = Math.sqrt(d8);
        double[] dArray3 = new double[this.am.length];
        for (int i = 0; i < this.am.length; ++i) {
            dArray3[i] = this.am[i] / d6;
        }
        double d9 = Math.sin(d4);
        double d10 = Math.cos(d4);
        double d11 = Math.sin(d5);
        double d12 = Math.cos(d5);
        double[] dArray4 = new double[]{d12 * d9, d11 * d9, d10};
        double d13 = 0.0;
        for (int i = 0; i < dArray4.length; ++i) {
            d13 += dArray4[i] * dArray4[i];
        }
        d13 = Math.sqrt(d13);
        double d14 = 0.0;
        double d15 = 0.0;
        d14 = dArray4[0] * dArray2[0] + dArray4[1] * dArray2[1] + dArray4[2] * dArray2[2];
        double d16 = 0.0;
        d15 = d8 == 0.0 ? 0.0 : d14 / (d8 * d13);
        d16 = Math.acos(d15);
        double d17 = this.computeGPD_Sum(dArray3, d, d2, d3, d6);
        double d18 = Math.exp(-1.43128817965125E17 * d8 * d8 * Math.sin(d16) * Math.sin(d16) * d17);
        double d19 = Math.exp(-d7 * (2.6751525E8 * d * d8 * Math.cos(d16) * (2.6751525E8 * d * d8 * Math.cos(d16))) * d3);
        double d20 = d18 * d19;
        return d20;
    }

    protected double computeGPD_Sum(double[] dArray, double d, double d2, double d3, double d4) {
        int n;
        if (this.lastDelta == d && this.lastDELTA == d2 && this.lastDiff == d3 && this.lastR == d4) {
            return this.lastSum;
        }
        double d5 = 0.0;
        for (n = 0; n < dArray.length; ++n) {
            double d6;
            double d7 = d3 * dArray[n] * dArray[n];
            double d8 = -d7 * d;
            double d9 = -d7 * d2;
            double d10 = d2 - d;
            double d11 = -d7 * d10;
            double d12 = d2 + d;
            double d13 = -d7 * d12;
            double d14 = 2.0 * d7 * d - 2.0 + 2.0 * Math.exp(d8) + 2.0 * Math.exp(d9) - Math.exp(d11) - Math.exp(d13);
            double d15 = d14 / (d6 = d7 * d7 * dArray[n] * dArray[n] * (d4 * d4 * dArray[n] * dArray[n] - 1.0));
            if (d15 < this.REQPREC * (d5 += d15)) break;
        }
        if (n == dArray.length) {
            logger.warning("Last term in CylinderGPD sum greater than " + this.REQPREC + " times sum.  May lack precision. R=" + d4 + ". diff=" + d3 + ". delta=" + d + ". DELTA=" + d2 + ".");
        }
        this.lastDelta = d;
        this.lastDELTA = d2;
        this.lastDiff = d3;
        this.lastR = d4;
        this.lastSum = d5;
        return d5;
    }
}

