/*
 * Decompiled with CFR 0.152.
 */
package models.compartments;

import imaging.DW_Scheme;
import imaging.StejskalTannerScheme;
import misc.LoggedException;
import models.compartments.CompartmentType;
import models.compartments.CylinderGPD;
import models.compartments.ListDistributionCompartment;
import numerics.GammaFunctions;
import numerics.RealMatrix;
import tools.CL_Initializer;

public class GDRCylinders
extends ListDistributionCompartment {
    private final double GAMMA = 2.6751525E8;
    private static double gamma_k;
    private static double gamma_beta;
    private static double theta;
    private static double phi;
    private static double d;
    private final int numBins;

    public GDRCylinders() {
        super(CompartmentType.GAMMADISTRIBRADIICYLINDERS.numParams, new CylinderGPD());
        this.numBins = 5;
    }

    public GDRCylinders(double d, double d2, double d3, double d4, double d5, int n) {
        super(GDRCylinders.getGammaDistrnListParams(n), "CylinderGPC", 5);
        gamma_k = d;
        gamma_beta = d2;
        theta = d3;
        phi = d4;
        GDRCylinders.d = d5;
        this.numBins = n;
    }

    public GDRCylinders(double d, double d2, double d3, double d4, double d5) {
        this(d, d2, d3, d4, d5, 5);
    }

    private static double[][] getGammaDistrnListParams(int n) {
        double d = gamma_k > 1.0 ? (gamma_k - 1.0) * gamma_beta : gamma_k * gamma_beta;
        double d2 = d / 10.0 * (double)n;
        double d3 = d;
        while (GDRCylinders.gammaCDF(gamma_k, gamma_beta, d3) > 1.0 / (double)n) {
            if (!((d3 -= d2) <= 0.0)) continue;
            d3 = 0.0;
            break;
        }
        double d4 = d3;
        d3 = d;
        int n2 = 0;
        while (GDRCylinders.gammaCDF(gamma_k, gamma_beta, d3) < 1.0 - 1.0 / (double)n) {
            ++n2;
            d3 += d2;
        }
        double d5 = d3;
        double d6 = d5 - d4;
        double d7 = d6 / (double)n;
        double[][] dArray = new double[n][CompartmentType.CYLINDERGPD.numParams + 1];
        for (int i = 0; i < n; ++i) {
            double d8;
            double d9 = d4 + ((double)i + 0.5) * d7;
            double d10 = d4 + (double)i * d7;
            double d11 = d4 + (double)(i + 1) * d7;
            dArray[i][0] = d8 = GDRCylinders.gammaPDF(gamma_k, gamma_beta, d10, d11) * d7;
            dArray[i][1] = GDRCylinders.d;
            dArray[i][2] = theta;
            dArray[i][3] = phi;
            dArray[i][4] = d9;
        }
        return dArray;
    }

    private static double gammaPDF(double d, double d2, double d3, double d4) {
        double d5 = GammaFunctions.gammln(d);
        double d6 = GammaFunctions.gammp(d, d3 / d2);
        double d7 = GammaFunctions.gammp(d, d4 / d2);
        return (d7 - d6) / Math.exp(d5) / (d4 - d3);
    }

    private static double gammaCDF(double d, double d2, double d3) {
        double d4 = GammaFunctions.gammp(d, d3 / d2);
        return d4;
    }

    @Override
    public RealMatrix getSignals(double[] dArray, DW_Scheme dW_Scheme) {
        StejskalTannerScheme stejskalTannerScheme;
        RealMatrix realMatrix = new RealMatrix(dW_Scheme.numMeasurements(), 1);
        gamma_k = dArray[0];
        gamma_beta = dArray[1];
        d = dArray[2];
        theta = dArray[3];
        phi = dArray[4];
        try {
            stejskalTannerScheme = (StejskalTannerScheme)dW_Scheme;
        }
        catch (ClassCastException classCastException) {
            throw new LoggedException("scheme object passed to cylinder compartment is not a StejskalTanner sequence");
        }
        double[][] dArray2 = GDRCylinders.getGammaDistrnListParams(this.numBins);
        for (int i = 0; i < dW_Scheme.numMeasurements(); ++i) {
            realMatrix.setEntry(i, 0, this.getWeightedCylinderSignal(dArray2, stejskalTannerScheme, i));
        }
        return realMatrix;
    }

    @Override
    public double getSignal(double[] dArray, DW_Scheme dW_Scheme, int n) {
        StejskalTannerScheme stejskalTannerScheme;
        gamma_k = dArray[0];
        gamma_beta = dArray[1];
        d = dArray[2];
        theta = dArray[3];
        phi = dArray[4];
        try {
            stejskalTannerScheme = (StejskalTannerScheme)dW_Scheme;
        }
        catch (ClassCastException classCastException) {
            throw new LoggedException("scheme object passed to cylinder compartment is not a StejskalTanner sequence");
        }
        double[][] dArray2 = GDRCylinders.getGammaDistrnListParams(this.numBins);
        return this.getWeightedCylinderSignal(dArray2, stejskalTannerScheme, n);
    }

    private double getWeightedCylinderSignal(double[][] dArray, StejskalTannerScheme stejskalTannerScheme, int n) {
        double d = 0.0;
        double[] dArray2 = new double[dArray[0].length];
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 1; j < dArray[0].length; ++j) {
                dArray2[j - 1] = dArray[i][j];
            }
            double d2 = this.model.getSignal(dArray2, stejskalTannerScheme, n);
            d += (d2 *= dArray[i][0]);
        }
        return d;
    }

    static {
        d = CL_Initializer.DIFF_CONST;
    }
}

