/*
 * Decompiled with CFR 0.152.
 */
package models.compartments;

import imaging.DW_Scheme;
import java.util.logging.Logger;
import misc.LoggedException;
import models.ParametricModel;
import models.compartments.CompartmentFactory;
import models.compartments.CompartmentType;
import numerics.RealMatrix;

public class ListDistributionCompartment
extends ParametricModel {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final double[][] param;
    private final double[] f;
    protected final ParametricModel model;

    public ListDistributionCompartment(int n, ParametricModel parametricModel) {
        super(n);
        this.param = null;
        this.f = null;
        this.model = parametricModel;
    }

    public ListDistributionCompartment(double[][] dArray, String string, int n) {
        super(n);
        CompartmentType compartmentType = CompartmentType.getCompartmentType(string);
        this.f = new double[dArray.length];
        this.param = new double[dArray.length][];
        for (int i = 0; i < dArray.length; ++i) {
            if (dArray[i].length - 1 != compartmentType.numParams) {
                throw new LoggedException("number of parameters at line " + i + " passed to list distribution(" + dArray[i].length + " does not match number required by model");
            }
            this.f[i] = dArray[i][0];
            this.param[i] = new double[dArray[i].length - 1];
            for (int j = 1; j < dArray[i].length; ++j) {
                this.param[j - 1] = dArray[j];
            }
        }
        this.model = CompartmentFactory.getCompartment(string);
    }

    @Override
    public RealMatrix getSignals(double[] dArray, DW_Scheme dW_Scheme) {
        RealMatrix realMatrix = new RealMatrix(dW_Scheme.numMeasurements(), 1);
        for (int i = 0; i < dW_Scheme.numMeasurements(); ++i) {
            realMatrix.setEntry(i, 0, this.getSignal(dArray, dW_Scheme, i));
        }
        return realMatrix;
    }

    @Override
    public double getSignal(double[] dArray, DW_Scheme dW_Scheme, int n) {
        double d = 0.0;
        for (int i = 0; i < this.param.length; ++i) {
            d += this.f[i] * this.model.getSignal(this.param[i], dW_Scheme, n);
        }
        return d;
    }
}

