/*
 * Decompiled with CFR 0.152.
 */
package models.compartments;

import imaging.DW_Scheme;
import models.ParametricModel;
import models.compartments.CompartmentType;
import numerics.RealMatrix;

public class Zeppelin
extends ParametricModel {
    public Zeppelin() {
        super(CompartmentType.ZEPPELIN.numParams);
    }

    @Override
    public RealMatrix getSignals(double[] dArray, DW_Scheme dW_Scheme) {
        RealMatrix realMatrix = new RealMatrix(dW_Scheme.numMeasurements(), 1);
        for (int i = 0; i < dW_Scheme.numMeasurements(); ++i) {
            realMatrix.setEntry(i, 0, this.getSignal(dArray, dW_Scheme, i));
        }
        return realMatrix;
    }

    @Override
    public double getSignal(double[] dArray, DW_Scheme dW_Scheme, int n) {
        double d = dArray[1];
        double d2 = dArray[2];
        double d3 = Math.sin(d);
        double d4 = Math.cos(d);
        double d5 = Math.sin(d2);
        double d6 = Math.cos(d2);
        double[] dArray2 = new double[]{d6 * d3, d5 * d3, d4};
        double d7 = dW_Scheme.getB_Value(n);
        double[] dArray3 = dW_Scheme.getG_Dir(n);
        double d8 = dArray2[0] * dArray3[0] + dArray2[1] * dArray3[1] + dArray2[2] * dArray3[2];
        double d9 = dArray[0];
        double d10 = dArray[3];
        double d11 = Math.exp(-d7 * ((d9 - d10) * d8 * d8 + d10));
        return d11;
    }

    @Override
    public RealMatrix getJacobian(double[] dArray, DW_Scheme dW_Scheme) {
        RealMatrix realMatrix = new RealMatrix(dW_Scheme.numMeasurements(), dArray.length);
        double d = dArray[0];
        double d2 = dArray[1];
        double d3 = dArray[2];
        double d4 = dArray[3];
        double d5 = Math.sin(d2);
        double d6 = Math.cos(d2);
        double d7 = Math.sin(d3);
        double d8 = Math.cos(d3);
        double[] dArray2 = new double[]{d8 * d5, d7 * d5, d6};
        for (int i = 0; i < dW_Scheme.numMeasurements(); ++i) {
            double d9 = dW_Scheme.getB_Value(i);
            double[] dArray3 = dW_Scheme.getG_Dir(i);
            double d10 = dArray2[0] * dArray3[0] + dArray2[1] * dArray3[1] + dArray2[2] * dArray3[2];
            double d11 = Math.exp(-d9 * ((d - d4) * d10 * d10 + d4));
            realMatrix.setEntry(i, 0, -d9 * d10 * d10 * d11);
            double d12 = -2.0 * d9 * (d - d4) * d10 * d11;
            realMatrix.setEntry(i, 1, d12 * (dArray3[0] * d6 * d8 + dArray3[1] * d6 * d7 - dArray3[2] * d5));
            realMatrix.setEntry(i, 2, d12 * (dArray3[1] * d5 * d8 - dArray3[0] * d5 * d7));
            realMatrix.setEntry(i, 3, -d9 * (1.0 - d10 * d10) * d11);
        }
        return realMatrix;
    }
}

