/*
 * Decompiled with CFR 0.152.
 */
package numerics;

public class BesselFunctions {
    private static final double ACC = 40.0;
    private static final double BIGNO = 1.0E10;
    private static final double BIGNI = 1.0E-10;

    public static double besselJ0(double d) {
        double d2;
        double d3;
        double d4 = Math.abs(d);
        if (d3 < 8.0) {
            double d5 = d * d;
            double d6 = 5.7568490574E10 + d5 * (-1.3362590354E10 + d5 * (6.516196407E8 + d5 * (-1.121442418E7 + d5 * (77392.33017 + d5 * -184.9052456))));
            double d7 = 5.7568490411E10 + d5 * (1.029532985E9 + d5 * (9494680.718 + d5 * (59272.64853 + d5 * (267.8532712 + d5 * 1.0))));
            d2 = d6 / d7;
        } else {
            double d8 = 8.0 / d4;
            double d9 = d8 * d8;
            double d10 = d4 - 0.785398164;
            double d11 = 1.0 + d9 * (-0.001098628627 + d9 * (2.734510407E-5 + d9 * (-2.073370639E-6 + d9 * 2.093887211E-7)));
            double d12 = -0.01562499995 + d9 * (1.430488765E-4 + d9 * (-6.911147651E-6 + d9 * (7.621095161E-7 - d9 * 9.34945152E-8)));
            d2 = Math.sqrt(0.636619772 / d4) * (Math.cos(d10) * d11 - d8 * Math.sin(d10) * d12);
        }
        return d2;
    }

    public static double besselJ1(double d) {
        double d2;
        double d3 = Math.abs(d);
        if (d3 < 8.0) {
            double d4 = d * d;
            double d5 = d * (7.2362614232E10 + d4 * (-7.895059235E9 + d4 * (2.423968531E8 + d4 * (-2972611.439 + d4 * (15704.4826 + d4 * -30.16036606)))));
            double d6 = 1.44725228442E11 + d4 * (2.300535178E9 + d4 * (1.858330474E7 + d4 * (99447.43394 + d4 * (376.9991397 + d4 * 1.0))));
            d2 = d5 / d6;
        } else {
            double d7 = 8.0 / d3;
            double d8 = d7 * d7;
            double d9 = d3 - 2.356194491;
            double d10 = 1.0 + d8 * (-0.00183105 + d8 * (-3.516396496E-5 + d8 * (-2.457520174E-6 + d8 * -2.40337019E-7)));
            double d11 = 0.04687499995 + d8 * (-2.002690873E-4 + d8 * (8.449199096E-6 + d8 * (-8.8228987E-7 - d8 * 1.05787412E-7)));
            d2 = Math.sqrt(0.636619772 / d3) * (Math.cos(d9) * d10 - d7 * Math.sin(d9) * d11);
            if (d < 0.0) {
                d2 = -d2;
            }
        }
        return d2;
    }

    public static double besselI0(double d) {
        double d2;
        double d3 = Math.abs(d);
        if (d3 < 3.75) {
            double d4 = d / 3.75;
            d4 *= d4;
            d2 = 1.0 + d4 * (3.5156229 + d4 * (3.0899424 + d4 * (1.2067492 + d4 * (0.2659732 + d4 * (0.0360768 + d4 * 0.0045813)))));
        } else {
            double d5 = 3.75 / d3;
            d2 = Math.exp(d3) / Math.sqrt(d3) * 0.39894228 + d5 * (0.01328592 + d5 * (0.00225319 + d5 * (-0.00157565 + d5 * (0.00916281 + d5 * (-0.02057706 + d5 * (0.02635537 + d5 * (-0.01647633 + d5 * 0.00392377)))))));
        }
        return d2;
    }

    public static double besselI1(double d) {
        double d2;
        double d3 = Math.abs(d);
        if (d3 < 3.75) {
            double d4 = d / 3.75;
            d4 *= d4;
            d2 = d3 * (0.5 + d4 * (0.87890594 + d4 * (0.51498869 + d4 * (0.15084934 + d4 * (0.02658733 + d4 * (0.00301532 + d4 * 0.0032411))))));
        } else {
            double d5 = 3.75 / d3;
            d2 = 0.02282967 + d5 * (-0.02895312 + d5 * (0.01787654 - d5 * 0.00420059));
            d2 = 0.39894228 + d5 * (-0.03988024 + d5 * (-0.00362018 + d5 * (0.00163801 + d5 * (-0.01031555 + d5 * d2))));
            d2 *= Math.exp(d3) / Math.sqrt(d3);
        }
        return d2;
    }

    public static double besselIn(int n, double d) {
        if (n == 0) {
            return BesselFunctions.besselI0(d);
        }
        if (n == 1) {
            return BesselFunctions.besselI1(d);
        }
        if (d == 0.0) {
            return 0.0;
        }
        double d2 = 2.0 / Math.abs(d);
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 1.0;
        for (int i = 2 * (n + (int)Math.sqrt(40.0 * (double)n)); i > 0; --i) {
            double d6 = d4 + (double)i * d2 * d5;
            d4 = d5;
            d5 = d6;
            if (Math.abs(d5) > 1.0E10) {
                d3 *= 1.0E-10;
                d5 *= 1.0E-10;
                d4 *= 1.0E-10;
            }
            if (i != n) continue;
            d3 = d4;
        }
        d3 *= BesselFunctions.besselI0(d) / d5;
        if (d < 0.0) {
            d3 = -d3;
        }
        return d3;
    }
}

