/*
 * Decompiled with CFR 0.152.
 */
package numerics;

import numerics.ComplexNumberException;

public class Complex
implements Cloneable {
    private double real;
    private double imaginary;

    public Complex(double d, double d2) {
        this.real = d;
        this.imaginary = d2;
    }

    public Complex() {
        this.real = 0.0;
        this.imaginary = 0.0;
    }

    public Object clone() {
        return new Complex(this.real, this.imaginary);
    }

    public double real() {
        return this.real;
    }

    public double imag() {
        return this.imaginary;
    }

    public double imaginary() {
        return this.imaginary;
    }

    public double mod() {
        return Math.sqrt(this.real * this.real + this.imaginary * this.imaginary);
    }

    public double mag() {
        return this.real * this.real + this.imaginary * this.imaginary;
    }

    public boolean equals(Complex complex) {
        return this.real == complex.real() && this.imaginary == complex.imaginary();
    }

    public boolean isZero() {
        return this.real == 0.0 && this.imaginary == 0.0;
    }

    public String toString() {
        return "(" + String.valueOf(this.real) + ") + (" + String.valueOf(this.imaginary) + ")i";
    }

    public Complex plus(Complex complex) {
        double d = this.real + complex.real();
        double d2 = this.imaginary + complex.imaginary();
        return new Complex(d, d2);
    }

    public Complex subtract(Complex complex) {
        double d = this.real - complex.real();
        double d2 = this.imaginary - complex.imaginary();
        return new Complex(d, d2);
    }

    public Complex times(Complex complex) {
        double d = this.real * complex.real() - this.imaginary * complex.imaginary();
        double d2 = this.real * complex.imaginary() + this.imaginary * complex.real();
        return new Complex(d, d2);
    }

    public Complex times(double d) {
        double d2 = this.real * d;
        double d3 = this.imaginary * d;
        return new Complex(d2, d3);
    }

    public Complex divide(Complex complex) throws ComplexNumberException {
        return this.times(complex.inverse());
    }

    public Complex negate() {
        double d = -this.real;
        double d2 = -this.imaginary;
        return new Complex(d, d2);
    }

    public Complex positive() {
        double d = Math.abs(this.real);
        double d2 = Math.abs(this.imaginary);
        return new Complex(d, d2);
    }

    public Complex inverse() throws ComplexNumberException {
        double d = this.real * this.real + this.imaginary * this.imaginary;
        if (d == 0.0) {
            throw new ComplexNumberException("Cannot reciprocate zero");
        }
        double d2 = this.real / d;
        double d3 = -this.imaginary / d;
        return new Complex(d2, d3);
    }

    public Complex conjugate() {
        return new Complex(this.real, -this.imaginary);
    }

    public Complex sqrt() {
        double d = this.mod();
        double d2 = 0.0;
        if (d != 0.0) {
            d2 = Math.atan(this.imaginary / this.real);
        }
        if (this.real < 0.0) {
            d2 += Math.PI;
        }
        double d3 = d2 / 2.0;
        double d4 = Math.sqrt(d);
        double d5 = d4 * Math.cos(d3);
        double d6 = d4 * Math.sin(d3);
        return new Complex(d5, d6);
    }

    public Complex sin() {
        double d = Math.sin(this.real) * Complex.cosh(this.imaginary);
        double d2 = Complex.sinh(this.imaginary) * Math.cos(this.real);
        return new Complex(d, d2);
    }

    public Complex cos() {
        double d = Math.cos(this.real) * Complex.cosh(this.imaginary);
        double d2 = -Math.sin(this.real) * Complex.sinh(this.imaginary);
        return new Complex(d, d2);
    }

    public Complex tan() throws ComplexNumberException {
        return this.sin().divide(this.cos());
    }

    public static double sinh(double d) {
        return 0.5 * (Math.exp(d) - Math.exp(-d));
    }

    public static double cosh(double d) {
        return 0.5 * (Math.exp(d) + Math.exp(-d));
    }

    public static double tanh(double d) {
        return (Math.exp(2.0 * d) - 1.0) / (Math.exp(2.0 * d) + 1.0);
    }

    public Complex sinh() {
        return new Complex(Complex.sinh(this.real) * Math.cos(this.imaginary), Complex.cosh(this.real) * Math.sin(this.imaginary));
    }

    public Complex cosh() {
        return new Complex(Complex.cosh(this.real) * Math.cos(this.imaginary), Complex.sinh(this.real) * Math.sin(this.imaginary));
    }

    public Complex tanh() {
        double d = Complex.cosh(2.0 * this.real) + Math.cos(2.0 * this.imaginary);
        return new Complex(Complex.sinh(2.0 * this.real) / d, Math.sin(2.0 * this.imaginary) / d);
    }
}

