/*
 * Decompiled with CFR 0.152.
 */
package numerics;

import Jama.Matrix;
import numerics.EigenSystem3D;
import numerics.RealMatrix;
import numerics.Vector3D;

public class SphericalDistributionFitter {
    public static RealMatrix tBar(Vector3D[] vector3DArray) {
        Matrix matrix = new Matrix(3, 3);
        for (int i = 0; i < vector3DArray.length; ++i) {
            Matrix matrix2 = vector3DArray[i].toJamaMatrix();
            matrix.plusEquals(matrix2.times(matrix2.transpose()).times(1.0 / (double)vector3DArray.length));
        }
        return new RealMatrix(matrix.getArray());
    }

    public static EigenSystem3D tBarEigenSystem(RealMatrix realMatrix) {
        return EigenSystem3D.sort(new Matrix(realMatrix.entries).eig());
    }

    public static EigenSystem3D tBarEigenSystem(Vector3D[] vector3DArray) {
        Matrix matrix = new Matrix(3, 3);
        for (int i = 0; i < vector3DArray.length; ++i) {
            Matrix matrix2 = vector3DArray[i].toJamaMatrix();
            matrix.plusEquals(matrix2.times(matrix2.transpose()).times(1.0 / (double)vector3DArray.length));
        }
        return EigenSystem3D.sort(matrix.eig());
    }

    public static EigenSystem3D tBarEigenSystem(double[] dArray, boolean bl) {
        if (bl) {
            return SphericalDistributionFitter.tBarEigenSystem(dArray);
        }
        double[] dArray2 = new double[]{dArray[0], dArray[1], dArray[3], dArray[2], dArray[4], dArray[5]};
        return SphericalDistributionFitter.tBarEigenSystem(dArray2);
    }

    public static EigenSystem3D tBarEigenSystem(double[] dArray) {
        Matrix matrix = new Matrix(3, 3);
        double d = dArray[0];
        double d2 = dArray[1];
        double d3 = dArray[2];
        double d4 = dArray[3];
        double d5 = dArray[4];
        double d6 = dArray[5];
        matrix.set(0, 0, d);
        matrix.set(1, 1, d4);
        matrix.set(2, 2, d6);
        matrix.set(0, 1, d2);
        matrix.set(1, 0, d2);
        matrix.set(0, 2, d3);
        matrix.set(2, 0, d3);
        matrix.set(1, 2, d5);
        matrix.set(2, 1, d5);
        return EigenSystem3D.sort(matrix.eig());
    }
}

