/*
 * Decompiled with CFR 0.152.
 */
package optimizers;

import fitters.Codec;
import imaging.DW_Scheme;
import models.ParametricModel;
import numerics.RealMatrix;
import optimizers.LM_Minimizer;
import optimizers.MarquardtMinimiserException;

public class LM_GaussianMinimizer
extends LM_Minimizer {
    public LM_GaussianMinimizer() {
    }

    public LM_GaussianMinimizer(DW_Scheme dW_Scheme, ParametricModel parametricModel, Codec codec) throws MarquardtMinimiserException {
        this.scheme = dW_Scheme;
        this.codec = codec;
        this.model = parametricModel;
        this.sig = new double[dW_Scheme.numMeasurements()];
        for (int i = 0; i < this.sig.length; ++i) {
            this.sig[i] = 1.0;
        }
        this.measurements = new double[dW_Scheme.numMeasurements()];
        this.init(this.codec.getNumOptParams());
    }

    @Override
    protected double fObj(double[] dArray, double[] dArray2, double[][] dArray3) {
        int n;
        int n2;
        double d = 0.0;
        for (int i = 1; i <= this.ma; ++i) {
            for (n2 = 1; n2 <= this.ma; ++n2) {
                dArray3[i][n2] = 0.0;
            }
            dArray2[i] = 0.0;
        }
        double[] dArray4 = new double[dArray.length - 1];
        for (n2 = 0; n2 < dArray.length - 1; ++n2) {
            dArray4[n2] = dArray[n2 + 1];
        }
        double[] dArray5 = this.codec.optToModel(dArray4);
        RealMatrix realMatrix = this.model.getSignals(dArray5, this.scheme);
        RealMatrix realMatrix2 = this.model.getJacobian(dArray5, this.scheme);
        RealMatrix realMatrix3 = this.codec.getJacobian(dArray4);
        RealMatrix realMatrix4 = realMatrix2.product(realMatrix3);
        boolean bl = false;
        if (bl) {
            int n3;
            System.err.println("modParams");
            for (n3 = 0; n3 < dArray5.length; ++n3) {
                System.err.print(dArray5[n3] + " ");
            }
            System.err.println();
            System.err.println("measurements");
            for (n3 = 0; n3 < this.measurements.length; ++n3) {
                System.err.print(this.measurements[n3] + " ");
            }
            System.err.println();
            System.err.println("modSignals");
            System.err.println(realMatrix);
            System.err.println("modJac");
            System.err.println(realMatrix2);
            System.err.println("codJac");
            System.err.println(realMatrix3);
            System.err.println("optJac");
            System.err.println(realMatrix4);
            RealMatrix realMatrix5 = this.numericalOptJac(dArray4);
            System.err.println("numerical optJac");
            System.err.println(realMatrix5);
        }
        for (n = 1; n <= this.scheme.numMeasurements(); ++n) {
            double d2 = realMatrix.entries[n - 1][0];
            double[] dArray6 = realMatrix4.entries[n - 1];
            double d3 = 1.0 / (this.sig[n - 1] * this.sig[n - 1]);
            double d4 = this.measurements[n - 1] - d2;
            int n4 = 1;
            while (n4 <= this.ma) {
                double d5 = 2.0 * dArray6[n4 - 1] * d3;
                for (int i = 1; i <= n4; ++i) {
                    double[] dArray7 = dArray3[i];
                    int n5 = n4;
                    dArray7[n5] = dArray7[n5] + d5 * dArray6[i - 1];
                }
                int n6 = n4++;
                dArray2[n6] = dArray2[n6] - d4 * d5;
            }
            d += d4 * d4 * d3;
        }
        for (n = 2; n <= this.ma; ++n) {
            for (int i = 1; i < n; ++i) {
                dArray3[n][i] = dArray3[i][n];
            }
        }
        if (bl) {
            System.err.println("chisq: " + d);
        }
        return d;
    }
}

