/*
 * Decompiled with CFR 0.152.
 */
package optimizers;

import fitters.Codec;
import imaging.DW_Scheme;
import models.ParametricModel;
import numerics.RealMatrix;
import optimizers.LM_GaussianMinimizer;
import optimizers.MarquardtMinimiserException;

public class LM_OffGaussMinimizer
extends LM_GaussianMinimizer {
    public LM_OffGaussMinimizer(DW_Scheme dW_Scheme, ParametricModel parametricModel, Codec codec, double d) throws MarquardtMinimiserException {
        this.scheme = dW_Scheme;
        this.codec = codec;
        this.model = parametricModel;
        this.sig = new double[dW_Scheme.numMeasurements()];
        for (int i = 0; i < this.sig.length; ++i) {
            this.sig[i] = d;
        }
        this.measurements = new double[dW_Scheme.numMeasurements()];
        this.init(this.codec.getNumOptParams());
    }

    @Override
    protected double fObj(double[] dArray, double[] dArray2, double[][] dArray3) {
        int n;
        int n2;
        double d = 0.0;
        for (int i = 1; i <= this.ma; ++i) {
            for (n2 = 1; n2 <= this.ma; ++n2) {
                dArray3[i][n2] = 0.0;
            }
            dArray2[i] = 0.0;
        }
        double[] dArray4 = new double[dArray.length - 1];
        for (n2 = 0; n2 < dArray.length - 1; ++n2) {
            dArray4[n2] = dArray[n2 + 1];
        }
        double[] dArray5 = this.codec.optToModel(dArray4);
        RealMatrix realMatrix = this.model.getSignals(dArray5, this.scheme);
        RealMatrix realMatrix2 = this.model.getJacobian(dArray5, this.scheme);
        RealMatrix realMatrix3 = this.codec.getJacobian(dArray4);
        RealMatrix realMatrix4 = realMatrix2.product(realMatrix3);
        for (n = 1; n <= this.scheme.numMeasurements(); ++n) {
            double d2 = this.sig[n - 1] * this.sig[n - 1];
            double d3 = 1.0 / d2;
            double d4 = realMatrix.entries[n - 1][0];
            d4 = Math.sqrt(d4 * d4 + d2);
            double[] dArray6 = realMatrix4.entries[n - 1];
            double d5 = this.measurements[n - 1] - d4;
            int n3 = 1;
            while (n3 <= this.ma) {
                double d6 = realMatrix.entries[n - 1][0] / d4;
                double d7 = 2.0 * dArray6[n3 - 1] * d3 * d6;
                for (int i = 1; i <= n3; ++i) {
                    double[] dArray7 = dArray3[i];
                    int n4 = n3;
                    dArray7[n4] = dArray7[n4] + d7 * dArray6[i - 1] * d6;
                }
                int n5 = n3++;
                dArray2[n5] = dArray2[n5] - d5 * d7;
            }
            d += d5 * d5 * d3;
        }
        for (n = 2; n <= this.ma; ++n) {
            for (int i = 1; i < n; ++i) {
                dArray3[n][i] = dArray3[i][n];
            }
        }
        return d;
    }
}

