/*
 * Decompiled with CFR 0.152.
 */
package optimizers;

import optimizers.PowellMinimiserException;

public abstract class PowellMinimiser {
    private static int ITMAX = 200;
    private static double BRENTTOL = 2.0E-4;
    protected double xx;
    protected double fx;
    protected double bx;
    protected double[] pcom;
    protected double[] xicom;
    protected double[] xit;
    protected int ncom;
    private static double GOLD = 1.618034;
    private static double GLIMIT = 100.0;
    private static double TINY = 1.0E-20;
    private static double BRENTITMAX = 100.0;
    private static double CGOLD = 0.381966;
    private static double ZEPS = 1.0E-10;
    protected double[][] xi;
    protected double[] pt;
    protected int iter;
    protected double fret;
    protected double xmin;
    protected double ax;
    protected double cx;
    protected double fa;
    protected double fb;
    protected double fc;
    protected double f;

    protected PowellMinimiser(int n) {
        this.xi = new double[n + 1][n + 1];
        for (int i = 1; i <= n; ++i) {
            for (int j = 1; j <= n; ++j) {
                this.xi[i][j] = i == j ? 1.0 : 0.0;
            }
        }
    }

    protected abstract double fObj(double[] var1);

    public double[] getMinParams() {
        return this.pt;
    }

    public double minimise(double[] dArray, double d) throws PowellMinimiserException {
        this.powell(dArray, dArray.length - 1, d);
        return this.fret;
    }

    private void powell(double[] dArray, int n, double d) throws PowellMinimiserException {
        int n2;
        this.pt = new double[n + 1];
        double[] dArray2 = new double[n + 1];
        this.xit = new double[n + 1];
        double d2 = 0.0;
        this.fret = this.fObj(dArray);
        for (n2 = 1; n2 <= n; ++n2) {
            this.pt[n2] = dArray[n2];
        }
        this.iter = 1;
        while (true) {
            double d3;
            double d4 = this.fret;
            int n3 = 0;
            double d5 = 0.0;
            for (n2 = 1; n2 <= n; ++n2) {
                for (int i = 1; i <= n; ++i) {
                    this.xit[i] = this.xi[i][n2];
                }
                d2 = this.fret;
                this.linmin(dArray, this.xit, n);
                if (!(Math.abs(d2 - this.fret) > d5)) continue;
                d5 = Math.abs(d2 - this.fret);
                n3 = n2;
            }
            if (2.0 * Math.abs(d4 - this.fret) <= d * (Math.abs(d4) + Math.abs(this.fret)) + TINY) {
                return;
            }
            if (this.iter == ITMAX) {
                throw new PowellMinimiserException("Powell exceeding maximum iterations.");
            }
            for (n2 = 1; n2 <= n; ++n2) {
                dArray2[n2] = 2.0 * dArray[n2] - this.pt[n2];
                this.pt[n2] = dArray[n2];
            }
            d2 = this.fObj(dArray2);
            if (d2 < d4 && (d3 = 2.0 * (d4 - 2.0 * this.fret + d2) * ((d4 - this.fret - d5) * (d4 - this.fret - d5)) * ((d4 - d2) * (d4 - d2))) < 0.0) {
                this.linmin(dArray, this.xit, n);
                for (n2 = 1; n2 <= n; ++n2) {
                    this.xi[n2][n3] = this.xi[n2][n];
                    this.xi[n2][n] = this.xit[n2];
                }
            }
            ++this.iter;
        }
    }

    private void linmin(double[] dArray, double[] dArray2, int n) throws PowellMinimiserException {
        int n2;
        this.pcom = new double[n + 1];
        this.xicom = new double[n + 1];
        this.ncom = n;
        for (n2 = 1; n2 <= n; ++n2) {
            this.pcom[n2] = dArray[n2];
            this.xicom[n2] = dArray2[n2];
        }
        this.ax = 0.0;
        this.bx = 1.0;
        this.mnbrak();
        this.fret = this.brent();
        for (n2 = 1; n2 <= n; ++n2) {
            int n3 = n2;
            dArray2[n3] = dArray2[n3] * this.xmin;
            int n4 = n2;
            dArray[n4] = dArray[n4] + dArray2[n2];
        }
    }

    private double brent() throws PowellMinimiserException {
        double d;
        double d2;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = this.ax < this.cx ? this.ax : this.cx;
        double d8 = this.ax > this.cx ? this.ax : this.cx;
        double d9 = d2 = this.bx;
        double d10 = d2;
        double d11 = d = this.f1dim(d10);
        double d12 = d;
        int n = 1;
        while ((double)n <= BRENTITMAX) {
            double d13 = 0.5 * (d7 + d8);
            double d14 = BRENTTOL * Math.abs(d10) + ZEPS;
            double d15 = 2.0 * d14;
            if (Math.abs(d10 - d13) <= d15 - 0.5 * (d8 - d7)) {
                this.xmin = d10;
                return d;
            }
            if (Math.abs(d3) > d14) {
                double d16 = (d10 - d9) * (d - d11);
                double d17 = (d10 - d2) * (d - d12);
                double d18 = (d10 - d2) * d17 - (d10 - d9) * d16;
                if ((d17 = 2.0 * (d17 - d16)) > 0.0) {
                    d18 = -d18;
                }
                d17 = Math.abs(d17);
                double d19 = d3;
                d3 = d4;
                if (Math.abs(d18) >= Math.abs(0.5 * d17 * d19) || d18 <= d17 * (d7 - d10) || d18 >= d17 * (d8 - d10)) {
                    d3 = d10 >= d13 ? d7 - d10 : d8 - d10;
                    d4 = CGOLD * d3;
                } else {
                    d4 = d18 / d17;
                    d5 = d10 + d4;
                    if (d5 - d7 < d15 || d8 - d5 < d15) {
                        d4 = this.sign(d14, d13 - d10);
                    }
                }
            } else {
                d3 = d10 >= d13 ? d7 - d10 : d8 - d10;
                d4 = CGOLD * d3;
            }
            d5 = Math.abs(d4) >= d14 ? d10 + d4 : d10 + this.sign(d14, d4);
            d6 = this.f1dim(d5);
            if (d6 <= d) {
                if (d5 >= d10) {
                    d7 = d10;
                } else {
                    d8 = d10;
                }
                d2 = d9;
                d9 = d10;
                d10 = d5;
                d11 = d12;
                d12 = d;
                d = d6;
            } else {
                if (d5 < d10) {
                    d7 = d5;
                } else {
                    d8 = d5;
                }
                if (d6 <= d12 || d9 == d10) {
                    d2 = d9;
                    d9 = d5;
                    d11 = d12;
                    d12 = d6;
                } else if (d6 <= d11 || d2 == d10 || d2 == d9) {
                    d2 = d5;
                    d11 = d6;
                }
            }
            ++n;
        }
        if ((double)n >= BRENTITMAX) {
            throw new PowellMinimiserException("Too many iterations in brent");
        }
        this.xmin = d10;
        return d;
    }

    private double f1dim(double d) {
        double[] dArray = new double[this.ncom + 1];
        for (int i = 1; i <= this.ncom; ++i) {
            dArray[i] = this.pcom[i] + d * this.xicom[i];
        }
        this.f = this.fObj(dArray);
        return this.f;
    }

    private void mnbrak() {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        this.fa = this.f1dim(this.ax);
        this.fb = this.f1dim(this.bx);
        if (this.fb > this.fa) {
            double d4 = this.ax;
            this.ax = this.bx;
            this.bx = d4;
            d4 = this.fb;
            this.fb = this.fa;
            this.fa = d4;
        }
        this.cx = this.bx + GOLD * (this.bx - this.ax);
        while (this.fb > this.fc) {
            double d5 = (this.bx - this.ax) * (this.fb - this.fc);
            double d6 = (this.bx - this.cx) * (this.fb - this.fa);
            d = this.bx - ((this.bx - this.cx) * d6 - (this.bx - this.ax) * d5) / (2.0 * this.sign(Math.max(Math.abs(d6 - d5), TINY), d6 - d5));
            d3 = this.bx + GLIMIT * (this.cx - this.bx);
            if ((this.bx - d) * (d - this.cx) > 0.0) {
                d2 = this.f1dim(d);
                if (d2 < this.fc) {
                    this.ax = this.bx;
                    this.bx = d;
                    this.fa = this.fb;
                    this.fb = d2;
                    return;
                }
                d = this.cx + GOLD * (this.cx - this.bx);
                d2 = this.f1dim(d);
            } else if ((this.cx - d) * (d - d3) > 0.0) {
                d2 = this.f1dim(d);
                if (d2 < this.fc) {
                    this.bx = this.cx;
                    this.cx = d;
                    d = this.cx + GOLD * (this.cx - this.bx);
                    this.fb = this.fc;
                    this.fc = d2;
                    d2 = this.f1dim(d);
                } else if ((d - d3) * (d3 - this.cx) >= 0.0) {
                    d = d3;
                    d2 = this.f1dim(d);
                } else {
                    d = this.cx + GOLD * (this.cx - this.bx);
                    d2 = this.f1dim(d);
                }
            }
            this.ax = this.bx;
            this.bx = this.cx;
            this.cx = d;
            this.fa = this.fb;
            this.fb = this.fc;
            this.fc = d2;
        }
    }

    private double sign(double d, double d2) {
        return d2 >= 0.0 ? Math.abs(d) : -Math.abs(d);
    }
}

