/*
 * Decompiled with CFR 0.152.
 */
package simulation.dynamics;

import java.util.logging.Logger;
import simulation.dynamics.StepAmender;
import simulation.dynamics.Walker;
import simulation.geometry.substrates.Substrate;

public class ElasticReflector
implements StepAmender {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final int D = 3;
    private final Substrate substrate;

    public ElasticReflector(Substrate substrate) {
        this.substrate = substrate;
    }

    @Override
    public void amendStep(Walker walker, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, double d, double[] dArray6, double[] dArray7, double[] dArray8, double[] dArray9, double d2, int n) {
        int n2;
        int n3;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double[] dArray10 = new double[3];
        double[] dArray11 = this.substrate.mapStepIntoSubstrate(walker, dArray2, dArray3);
        double[] dArray12 = dArray11 != dArray3 ? this.substrate.mapStepIntoSubstrate(walker, dArray2, dArray2) : dArray2;
        for (int i = 0; i < 3; ++i) {
            d5 += dArray11[i] * dArray11[i];
            dArray10[i] = dArray[i];
            d3 += dArray4[i] * dArray10[i];
            d4 += dArray4[i] * dArray11[i];
        }
        d5 = Math.sqrt(d5);
        double d6 = d4 / d5;
        double d7 = Math.abs(d3 - dArray5[0]);
        if (d7 <= d5 * 1.0E-12) {
            d7 = d5 * 1.0E-12;
        }
        double d8 = 1.0;
        if (d6 != 0.0) {
            d8 = Math.abs(d7 / d6);
        } else {
            this.logger.warning("WARNING: attempt to amend a step that is parallel to membrane!");
            this.logger.warning("walker.r=(" + walker.r[0] + "," + walker.r[1] + "," + walker.r[2] + "), " + "step = (" + dArray11[0] + "," + dArray11[1] + "," + dArray11[2] + ") normal=(" + dArray4[0] + "," + dArray4[1] + "," + dArray4[2] + ")");
        }
        if (d8 > d5) {
            String string = new String("erroneously detected membrane crossing in diffusion sim!\ndistance to membrane " + d8 + " is greater than step length " + d5 + " d[0]= " + dArray5[0] + " distToPlane= " + d7 + " cosTheta= " + d6 + " t=" + d2 + " walker " + n);
            this.logger.severe(string);
            throw new RuntimeException(string);
        }
        double[] dArray13 = new double[3];
        double d9 = 0.0;
        for (n3 = 0; n3 < 3; ++n3) {
            dArray13[n3] = d8 * (dArray11[n3] / d5);
            d9 += dArray13[n3] * dArray4[n3];
            dArray6[n3] = Substrate.factor * dArray13[n3];
            dArray8[n3] = (d5 - d8) * (dArray11[n3] / d5);
        }
        for (n3 = 0; n3 < 3; ++n3) {
            double d10 = dArray13[n3] - 2.0 * d9 * dArray4[n3];
            d10 /= d8;
            dArray7[n3] = d10 *= d5 - d8;
        }
        double d11 = 0.0;
        double d12 = 0.0;
        double d13 = 0.0;
        for (n2 = 0; n2 < 3; ++n2) {
            d11 += dArray11[n2] * dArray11[n2];
            d12 += dArray7[n2] * dArray7[n2];
            d13 += dArray8[n2] * dArray8[n2];
        }
        d11 = Math.sqrt(d11);
        d12 = Math.sqrt(d12);
        d13 = Math.sqrt(d13);
        if (d11 > d5) {
            this.logger.warning("amended step longer than original!");
        }
        if (d12 / d <= 1.0E-12) {
            for (n2 = 0; n2 < 3; ++n2) {
                dArray7[n2] = 0.0;
            }
        }
        if (d13 / d <= 1.0E-12) {
            for (n2 = 0; n2 < 3; ++n2) {
                dArray8[n2] = 0.0;
            }
        }
        if (dArray11 != dArray3) {
            double[] dArray14 = this.substrate.unmapStepFromSubstrate(dArray, dArray12, dArray6);
            double[] dArray15 = this.substrate.unmapStepFromSubstrate(dArray, dArray12, dArray7);
            double[] dArray16 = this.substrate.unmapStepFromSubstrate(dArray, dArray12, dArray8);
            for (int i = 0; i < 3; ++i) {
                dArray6[i] = dArray14[i];
                dArray7[i] = dArray15[i];
                dArray8[i] = dArray16[i];
            }
        }
    }
}

