/*
 * Decompiled with CFR 0.152.
 */
package simulation.dynamics;

import java.util.logging.Logger;
import simulation.DiffusionSimulation;
import simulation.SimulationParams;
import simulation.dynamics.CylindricalSurfaceStepGenerator;
import simulation.dynamics.FixedLengthStepGenerator;
import simulation.dynamics.StepGenerator;

public class StepGeneratorFactory {
    private static Logger logger = Logger.getLogger("simulation.StepGeneratorFactory");
    private static StepGenerator flStepGen = null;
    private static StepGenerator csStepGen = null;

    public static final StepGenerator getStepGenerator(SimulationParams simulationParams) {
        StepType stepType = simulationParams.getStepType();
        if (stepType == StepType.FIXEDLENGTH) {
            if (flStepGen == null) {
                logger.info("instantiating fixed length step generator");
                FixedLengthStepGenerator fixedLengthStepGenerator = new FixedLengthStepGenerator(simulationParams);
                flStepGen = fixedLengthStepGenerator;
                return fixedLengthStepGenerator;
            }
            return flStepGen;
        }
        if (stepType == StepType.CYLINDRICAL) {
            if (csStepGen == null) {
                logger.info("instantiating cylinderical surface step generator");
                CylindricalSurfaceStepGenerator cylindricalSurfaceStepGenerator = new CylindricalSurfaceStepGenerator(simulationParams);
                csStepGen = cylindricalSurfaceStepGenerator;
                return cylindricalSurfaceStepGenerator;
            }
            return csStepGen;
        }
        String string = new String("unknown diffusion simulation step generator type code " + (Object)((Object)stepType));
        logger.severe(string);
        throw new RuntimeException(string);
    }

    public static final double[] getStepParamsArray(StepType stepType, SimulationParams simulationParams) {
        if (stepType == StepType.FIXEDLENGTH) {
            double d = Math.sqrt(6.0 * DiffusionSimulation.DIFF_CONST * simulationParams.getDt());
            return new double[]{d};
        }
        if (stepType == StepType.CYLINDRICAL) {
            double d = Math.sqrt(6.0 * DiffusionSimulation.DIFF_CONST * simulationParams.getDt());
            double d2 = Math.sqrt(4.0 * SimulationParams.sim_surfaceDiffusivity * simulationParams.getDt());
            return new double[]{d, d2};
        }
        logger.warning("unknown step generator type " + (Object)((Object)stepType) + " paramters array " + "for fixed length step generator will be returned instead.");
        return StepGeneratorFactory.getStepParamsArray(StepType.FIXEDLENGTH, simulationParams);
    }

    public static enum StepType {
        FIXEDLENGTH,
        SPATIALLYVARYING,
        CYLINDRICAL;

    }
}

