/*
 * Decompiled with CFR 0.152.
 */
package simulation.dynamics;

import java.io.DataOutputStream;
import java.util.logging.Logger;
import numerics.MTRandom;
import simulation.dynamics.StepGenerator;
import simulation.dynamics.Walker;
import simulation.geometry.substrates.StickyCylinderSubstrate;
import simulation.geometry.substrates.Substrate;
import simulation.measurement.SyntheticScan;
import tools.CL_Initializer;

public class StickyWalker
extends Walker {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final int D = 3;
    public boolean free;
    private final StepGenerator surfaceStepGen;
    private final double p_unstick;
    private static MTRandom surfaceTwister = new MTRandom(CL_Initializer.seed + 27834);
    public boolean wasExtracellular;
    private final StickyCylinderSubstrate substrate;
    public int numSticks = 0;
    public double lastStickTime = 0.0;
    public double totalTimeStuck = 0.0;

    public StickyWalker(double[] dArray, StepGenerator stepGenerator, StepGenerator stepGenerator2, Substrate substrate, SyntheticScan syntheticScan, DataOutputStream dataOutputStream, boolean bl, double d) {
        super(dArray, stepGenerator, substrate, syntheticScan, dataOutputStream);
        this.surfaceStepGen = stepGenerator2;
        this.free = bl;
        this.p_unstick = d;
        this.substrate = (StickyCylinderSubstrate)substrate;
    }

    public StickyWalker(double[] dArray, StepGenerator stepGenerator, Substrate substrate, boolean bl) {
        super(dArray, substrate);
        this.free = bl;
        this.surfaceStepGen = stepGenerator;
        this.p_unstick = 0.0;
        this.substrate = (StickyCylinderSubstrate)substrate;
    }

    public StickyWalker(double[] dArray) {
        super(dArray);
        this.free = false;
        this.surfaceStepGen = null;
        this.p_unstick = 0.0;
        this.substrate = null;
    }

    @Override
    public void update(double d, int n, int n2) {
        if (this.free) {
            super.update(d, n, n2);
        } else {
            this.step = this.surfaceStepGen.getStep(this);
            this.substrate.amend((Walker)this, this.step, d, n2);
            this.makeStep(this.step);
        }
    }

    public void getSubsCoords(double[] dArray) {
        double[] dArray2 = new double[]{0.0, 0.0, 0.0};
        this.substrate.getSubstrateCoords(this.r, dArray2, dArray);
    }

    public static void main(String[] stringArray) {
    }
}

